/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.tasks;

import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public interface SavePipelineTemplateTask {
    default public void validate(PipelineTemplate template) {
        List invalidVariableNames;
        if (template.getId().contains(".")) {
            throw new IllegalArgumentException("Pipeline Template IDs cannot have dots");
        }
        ArrayList<String> missingFields = new ArrayList<String>();
        if (template.getMetadata().getName() == null || "".equalsIgnoreCase(template.getMetadata().getName())) {
            missingFields.add("metadata.name");
        }
        if (template.getMetadata().getDescription() == null || "".equalsIgnoreCase(template.getMetadata().getDescription())) {
            missingFields.add("metadata.description");
        }
        if (template.getMetadata().getScopes() == null || template.getMetadata().getScopes().isEmpty()) {
            missingFields.add("metadata.scopes");
        }
        if (!missingFields.isEmpty()) {
            throw new IllegalArgumentException("Missing required fields: " + String.join((CharSequence)",", missingFields));
        }
        if (template.getVariables() != null && !(invalidVariableNames = template.getVariables().stream().filter(variable -> variable.getName() != null && variable.getName().contains("-")).map(PipelineTemplate.Variable::getName).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException("Variable names cannot include dashes (-). Invalid variable names: " + String.join((CharSequence)", ", invalidVariableNames));
        }
    }
}

