/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.tasks.v2;

import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteV2PipelineTemplateTask
implements RetryableTask {
    @Autowired(required=false)
    private Front50Service front50Service;

    public TaskResult execute(StageExecution stage) {
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 is not enabled, no way to delete pipeline. Fix this by setting front50.enabled: true");
        }
        if (!stage.getContext().containsKey("pipelineTemplateId")) {
            throw new IllegalArgumentException("Missing required task parameter (pipelineTemplateId)");
        }
        String templateId = (String)stage.getContext().get("pipelineTemplateId");
        String tag = (String)stage.getContext().get("tag");
        String digest = (String)stage.getContext().get("digest");
        this.front50Service.deleteV2PipelineTemplate(templateId, tag, digest);
        HashMap<String, String> outputs = new HashMap<String, String>();
        outputs.put("notification.type", "deletepipelinetemplate");
        outputs.put("pipeline.id", templateId);
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(outputs).build();
    }

    public long getBackoffPeriod() {
        return 15000L;
    }

    public long getTimeout() {
        return TimeUnit.MINUTES.toMillis(1L);
    }
}

