/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.tasks.v2;

import com.google.common.base.Strings;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2PipelineTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public interface SaveV2PipelineTemplateTask {
    default public void validate(V2PipelineTemplate template) {
        List invalidVariableNames;
        if (template.getId().contains(".")) {
            throw new IllegalArgumentException("Pipeline Template IDs cannot have dots");
        }
        ArrayList<String> missingFields = new ArrayList<String>();
        if (Strings.isNullOrEmpty((String)template.getMetadata().getName())) {
            missingFields.add("metadata.name");
        }
        if (Strings.isNullOrEmpty((String)template.getMetadata().getDescription())) {
            missingFields.add("metadata.description");
        }
        if (template.getMetadata().getScopes() == null || template.getMetadata().getScopes().isEmpty()) {
            missingFields.add("metadata.scopes");
        }
        if (Strings.isNullOrEmpty((String)template.getSchema())) {
            missingFields.add("schema");
        }
        if (!missingFields.isEmpty()) {
            throw new IllegalArgumentException("Missing required fields: " + String.join((CharSequence)",", missingFields));
        }
        if (!template.getSchema().equals("v2")) {
            throw new IllegalArgumentException(String.format("Invalid schema version: %s", template.getSchema()));
        }
        if (!template.getMetadata().getName().matches("^[a-zA-z0-9-&\\s]+$")) {
            throw new IllegalArgumentException(String.format("Illegal template name: %s. Name must match the regex: %s", template.getMetadata().getName(), "^[a-zA-z0-9-&\\s]+$"));
        }
        if (template.getVariables() != null && !(invalidVariableNames = template.getVariables().stream().filter(variable -> variable.getName() != null && !variable.getName().matches("^[a-zA-Z0-9_]+$")).map(V2PipelineTemplate.Variable::getName).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException(String.format("Illegal variable names: %s. Variable names must match the regex: %s", String.join((CharSequence)", ", invalidVariableNames), "^[a-zA-Z0-9_]+$"));
        }
    }
}

