/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.tasks.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import com.netflix.spinnaker.orca.pipelinetemplate.tasks.v2.SaveV2PipelineTemplateTask;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2PipelineTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import retrofit.client.Response;

@Component
public class UpdateV2PipelineTemplateTask
implements RetryableTask,
SaveV2PipelineTemplateTask {
    @Autowired(required=false)
    private Front50Service front50Service;
    @Autowired
    private ObjectMapper pipelineTemplateObjectMapper;

    public TaskResult execute(StageExecution stage) {
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 is not enabled, no way to save pipeline templates. Fix this by setting front50.enabled: true");
        }
        if (!stage.getContext().containsKey("pipelineTemplate")) {
            throw new IllegalArgumentException("Missing required task parameter (pipelineTemplate)");
        }
        if (!(stage.getContext().get("pipelineTemplate") instanceof String) || !Base64.isBase64((String)((String)stage.getContext().get("pipelineTemplate")))) {
            throw new IllegalArgumentException("'pipelineTemplate' context key must be a base64-encoded string: Ensure you're on the most recent version of gate");
        }
        ArrayList<String> missingParams = new ArrayList<String>();
        if (!stage.getContext().containsKey("id")) {
            missingParams.add("id");
        }
        if (!stage.getContext().containsKey("pipelineTemplate")) {
            missingParams.add("pipelineTemplate");
        }
        if (!missingParams.isEmpty()) {
            throw new IllegalArgumentException("Missing required task parameter (" + StringUtils.arrayToCommaDelimitedString((Object[])missingParams.toArray()) + ")");
        }
        V2PipelineTemplate pipelineTemplate = (V2PipelineTemplate)((StageExecutionImpl)stage).decodeBase64("/pipelineTemplate", V2PipelineTemplate.class, this.pipelineTemplateObjectMapper);
        this.validate(pipelineTemplate);
        String tag = (String)stage.getContext().get("tag");
        Response response = this.front50Service.updateV2PipelineTemplate((String)stage.getContext().get("id"), tag, (Map)((StageExecutionImpl)stage).decodeBase64("/pipelineTemplate", Map.class, this.pipelineTemplateObjectMapper));
        String templateId = StringUtils.isEmpty((Object)tag) ? pipelineTemplate.getId() : String.format("%s:%s", pipelineTemplate.getId(), tag);
        HashMap<String, String> outputs = new HashMap<String, String>();
        outputs.put("notification.type", "updatepipelinetemplate");
        outputs.put("pipelineTemplate.id", templateId);
        if (response.getStatus() == HttpStatus.OK.value()) {
            return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(outputs).build();
        }
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.TERMINAL).context(outputs).build();
    }

    public long getBackoffPeriod() {
        return 15000L;
    }

    public long getTimeout() {
        return TimeUnit.MINUTES.toMillis(1L);
    }
}

