/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;

public class MapMerge {
    public static Map<String, Object> merge(Map<String, Object> original, Map<String, Object> overrides) {
        Map source = Optional.ofNullable(original).orElse(Collections.emptyMap());
        Map override = Optional.ofNullable(overrides).orElse(Collections.emptyMap());
        LinkedHashSet remainingKeys = new LinkedHashSet(override.keySet());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : source.entrySet()) {
            String key = (String)entry.getKey();
            result.put(key, entry.getValue());
            if (override.containsKey(key)) {
                Object value = override.get(key);
                if (value == null) {
                    result.remove(key);
                } else {
                    result.merge(key, value, MapMerge::mergeObject);
                }
            }
            remainingKeys.remove(key);
        }
        for (String newKey : remainingKeys) {
            result.put(newKey, override.get(newKey));
        }
        return result;
    }

    private static Object mergeObject(Object original, Object override) {
        if (original instanceof Map) {
            if (!(override instanceof Map)) {
                throw new IllegalStateException("Attempt to merge Map with " + override.getClass().getSimpleName());
            }
            return MapMerge.merge(MapMerge.toMap(original), MapMerge.toMap(override));
        }
        if (original instanceof Collection && !(override instanceof Collection)) {
            throw new IllegalStateException("Attempt to replace Collection with " + override.getClass().getSimpleName());
        }
        return override;
    }

    private static Map<String, Object> toMap(Object o) {
        return (Map)o;
    }
}

