/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema;

import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.MapMerge;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.Identifiable;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedContent;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TemplateMerge {
    public static PipelineTemplate merge(List<PipelineTemplate> templates) {
        PipelineTemplate result = new PipelineTemplate();
        result.setId("mergedTemplate");
        result.setSchema(templates.get(0).getSchema());
        for (PipelineTemplate template : templates) {
            TemplateMerge.appendSource(result, template);
            if (template.getProtect().booleanValue()) {
                result.setProtect(true);
            }
            result.setVariables(TemplateMerge.mergeNamedContent(result.getVariables(), template.getVariables()));
            TemplateMerge.mergeConfiguration(result, template);
            result.setStages(TemplateMerge.mergeIdentifiable(result.getStages(), template.getStages()));
            result.setModules(TemplateMerge.mergeIdentifiable(result.getModules(), template.getModules()));
            result.setPartials(TemplateMerge.mergeIdentifiable(result.getPartials(), template.getPartials()));
        }
        result.setMetadata(templates.get(templates.size() - 1).getMetadata());
        return result;
    }

    private static void appendSource(PipelineTemplate a, PipelineTemplate b) {
        if (a.getSource() == null || a.getSource().equals("")) {
            a.setSource(b.getSource());
        } else if (b.getSource() != null) {
            a.setSource(a.getSource() + "," + b.getSource());
        }
    }

    private static void mergeConfiguration(PipelineTemplate a, PipelineTemplate b) {
        if (a.getConfiguration() == null) {
            a.setConfiguration(b.getConfiguration());
            return;
        }
        PipelineTemplate.Configuration aConfig = a.getConfiguration();
        PipelineTemplate.Configuration bConfig = b.getConfiguration();
        aConfig.setConcurrentExecutions(MapMerge.merge(aConfig.getConcurrentExecutions(), bConfig.getConcurrentExecutions()));
        aConfig.setTriggers(TemplateMerge.mergeNamedContent(aConfig.getTriggers(), bConfig.getTriggers()));
        aConfig.setParameters(TemplateMerge.mergeNamedContent(aConfig.getParameters(), bConfig.getParameters()));
        aConfig.setNotifications(TemplateMerge.mergeNamedContent(aConfig.getNotifications(), bConfig.getNotifications()));
        aConfig.setExpectedArtifacts(TemplateMerge.mergeDistinct(aConfig.getExpectedArtifacts(), bConfig.getExpectedArtifacts()));
    }

    public static <T> List<T> mergeDistinct(List<T> a, List<T> b) {
        if (a == null || a.size() == 0) {
            return b;
        }
        if (b == null || b.size() == 0) {
            return a;
        }
        ArrayList<T> merged = new ArrayList<T>();
        merged.addAll(a);
        merged.addAll(b);
        return merged.stream().distinct().collect(Collectors.toList());
    }

    public static <T extends NamedContent> List<T> mergeNamedContent(List<T> a, List<T> b) {
        if (a == null || a.size() == 0) {
            return b;
        }
        if (b == null || b.size() == 0) {
            return a;
        }
        ArrayList<Object> merged = new ArrayList<Object>();
        merged.addAll(a);
        for (NamedContent bNode : b) {
            boolean updated = false;
            for (int i = 0; i < merged.size(); ++i) {
                if (!((NamedContent)merged.get(i)).getName().equals(bNode.getName())) continue;
                if (bNode.isRemove()) {
                    merged.remove(i);
                } else if (bNode.isMerge()) {
                    merged.set(i, ((NamedContent)merged.get(i)).merge(bNode));
                } else {
                    merged.set(i, bNode);
                }
                updated = true;
                break;
            }
            if (updated) continue;
            merged.add(bNode);
        }
        return merged;
    }

    public static <T extends Identifiable> List<T> mergeIdentifiable(List<T> a, List<T> b) {
        if (a == null || a.size() == 0) {
            return b;
        }
        if (b == null || b.size() == 0) {
            return a;
        }
        ArrayList<Object> merged = new ArrayList<Object>();
        merged.addAll(a);
        for (Identifiable bNode : b) {
            boolean updated = false;
            for (int i = 0; i < merged.size(); ++i) {
                if (!((Identifiable)merged.get(i)).getId().equals(bNode.getId())) continue;
                merged.set(i, bNode);
                updated = true;
                break;
            }
            if (updated) continue;
            merged.add(bNode);
        }
        return merged;
    }
}

