/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.front50.PipelineModelMutator;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateLoaderException;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.TemplateLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.TemplateMerge;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedHashMap;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderUtil;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedPipelineModelMutator
implements PipelineModelMutator {
    private static final Logger log = LoggerFactory.getLogger(TemplatedPipelineModelMutator.class);
    private final ObjectMapper pipelineTemplateObjectMapper;
    private final TemplateLoader templateLoader;
    private final Renderer renderer;

    public TemplatedPipelineModelMutator(ObjectMapper pipelineTemplateObjectMapper, TemplateLoader templateLoader, Renderer renderer) {
        this.pipelineTemplateObjectMapper = pipelineTemplateObjectMapper;
        this.templateLoader = templateLoader;
        this.renderer = renderer;
    }

    public boolean supports(Map<String, Object> pipeline) {
        return "templatedPipeline".equals(pipeline.get("type")) && pipeline.containsKey("config");
    }

    public void mutate(Map<String, Object> pipeline) {
        TemplateConfiguration configuration = (TemplateConfiguration)this.pipelineTemplateObjectMapper.convertValue(pipeline.get("config"), TemplateConfiguration.class);
        PipelineTemplate template = null;
        if (!this.sourceContainsExpressions(configuration) && (template = this.getPipelineTemplate(configuration)) != null) {
            this.applyConfigurationsFromTemplate(configuration.getConfiguration(), template.getConfiguration(), pipeline);
        }
        this.mapRootPipelineConfigs(pipeline, configuration);
        this.applyConfigurations(configuration.getConfiguration(), pipeline);
        this.renderConfigurations(pipeline, RenderUtil.createDefaultRenderContext(template, configuration, null));
    }

    private void mapRootPipelineConfigs(Map<String, Object> pipeline, TemplateConfiguration configuration) {
        Map p;
        Map config;
        if (pipeline.containsKey("id") && pipeline.get("id") != configuration.getPipeline().getPipelineConfigId()) {
            config = (Map)pipeline.get("config");
            p = (Map)config.get("pipeline");
            p.put("pipelineConfigId", pipeline.get("id"));
        }
        if (pipeline.containsKey("name") && pipeline.get("name") != configuration.getPipeline().getName()) {
            config = (Map)pipeline.get("config");
            p = (Map)config.get("pipeline");
            p.put("name", pipeline.get("name"));
        }
        if (pipeline.containsKey("application") && pipeline.get("application") != configuration.getPipeline().getApplication()) {
            config = (Map)pipeline.get("config");
            p = (Map)config.get("pipeline");
            p.put("application", pipeline.get("application"));
        }
    }

    private void applyConfigurationsFromTemplate(TemplateConfiguration.PipelineConfiguration configuration, PipelineTemplate.Configuration templateConfiguration, Map<String, Object> pipeline) {
        if (configuration.getInherit().contains("concurrentExecutions") && templateConfiguration.getConcurrentExecutions() != null) {
            this.applyConcurrentExecutions(pipeline, templateConfiguration.getConcurrentExecutions());
        }
        if (configuration.getInherit().contains("triggers")) {
            pipeline.put("triggers", templateConfiguration.getTriggers());
        }
        if (configuration.getInherit().contains("parameters")) {
            pipeline.put("parameterConfig", templateConfiguration.getParameters());
        }
        if (configuration.getInherit().contains("notifications")) {
            pipeline.put("notifications", templateConfiguration.getNotifications());
        }
        if (configuration.getInherit().contains("expectedArtifacts")) {
            pipeline.put("expectedArtifacts", templateConfiguration.getExpectedArtifacts());
        }
    }

    private void applyConfigurations(TemplateConfiguration.PipelineConfiguration configuration, Map<String, Object> pipeline) {
        if (configuration.getConcurrentExecutions() != null) {
            this.applyConcurrentExecutions(pipeline, configuration.getConcurrentExecutions());
        }
        if (configuration.getTriggers() != null && !configuration.getTriggers().isEmpty()) {
            pipeline.put("triggers", TemplateMerge.mergeDistinct((List)this.pipelineTemplateObjectMapper.convertValue(pipeline.get("triggers"), (TypeReference)new TypeReference<List<NamedHashMap>>(){}), configuration.getTriggers()));
        }
        if (configuration.getParameters() != null && !configuration.getParameters().isEmpty()) {
            pipeline.put("parameterConfig", TemplateMerge.mergeNamedContent((List)this.pipelineTemplateObjectMapper.convertValue(pipeline.get("parameterConfig"), (TypeReference)new TypeReference<List<NamedHashMap>>(){}), configuration.getParameters()));
        }
        if (configuration.getNotifications() != null && !configuration.getNotifications().isEmpty()) {
            pipeline.put("notifications", TemplateMerge.mergeNamedContent((List)this.pipelineTemplateObjectMapper.convertValue(pipeline.get("notifications"), (TypeReference)new TypeReference<List<NamedHashMap>>(){}), configuration.getNotifications()));
        }
        if (configuration.getExpectedArtifacts() != null && !configuration.getExpectedArtifacts().isEmpty()) {
            pipeline.put("expectedArtifacts", TemplateMerge.mergeDistinct((List)this.pipelineTemplateObjectMapper.convertValue(pipeline.get("expectedArtifacts"), (TypeReference)new TypeReference<List<HashMap<String, Object>>>(){}), configuration.getExpectedArtifacts()));
        }
    }

    private void applyConcurrentExecutions(Map<String, Object> pipeline, Map<String, Object> concurrentExecutions) {
        if (concurrentExecutions.containsKey("limitConcurrent")) {
            pipeline.put("limitConcurrent", concurrentExecutions.get("limitConcurrent"));
        }
        if (concurrentExecutions.containsKey("maxConcurrentExecutions")) {
            pipeline.put("maxConcurrentExecutions", concurrentExecutions.get("maxConcurrentExecutions"));
        }
        if (concurrentExecutions.containsKey("keepWaitingPipelines")) {
            pipeline.put("keepWaitingPipelines", concurrentExecutions.get("keepWaitingPipelines"));
        }
        if (concurrentExecutions.containsKey("parallel")) {
            pipeline.put("parallel", concurrentExecutions.get("parallel"));
        }
    }

    private void renderConfigurations(Map<String, Object> pipeline, RenderContext renderContext) {
        if (pipeline.containsKey("triggers")) {
            pipeline.put("triggers", this.renderList((List)pipeline.get("triggers"), renderContext));
        }
        if (pipeline.containsKey("parameterConfig")) {
            pipeline.put("parameterConfig", this.renderList((List)pipeline.get("parameterConfig"), renderContext));
        }
        if (pipeline.containsKey("notifications")) {
            pipeline.put("notifications", this.renderList((List)pipeline.get("notifications"), renderContext));
        }
        if (pipeline.containsKey("expectedArtifacts")) {
            pipeline.put("expectedArtifacts", this.renderList((List)pipeline.get("expectedArtifacts"), renderContext));
        }
    }

    private List<Object> renderList(List<Object> list, RenderContext renderContext) {
        if (list == null) {
            return null;
        }
        return list.stream().map(i -> RenderUtil.deepRender(this.renderer, i, renderContext)).collect(Collectors.toList());
    }

    private boolean sourceContainsExpressions(TemplateConfiguration configuration) {
        String source = configuration.getPipeline().getTemplate().getSource();
        return source.contains("{{") || source.contains("{%");
    }

    private PipelineTemplate getPipelineTemplate(TemplateConfiguration configuration) {
        try {
            return TemplateMerge.merge(this.templateLoader.load(configuration.getPipeline().getTemplate()));
        }
        catch (TemplateLoaderException e) {
            log.error("Could not load template: {}", (Object)configuration.getPipeline().getTemplate(), (Object)e);
            return null;
        }
    }
}

