/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema;

import com.netflix.spinnaker.orca.pipelinetemplate.TemplatedPipelineRequest;
import com.netflix.spinnaker.orca.pipelinetemplate.generator.ExecutionGenerator;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.TemplateMerge;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class V1SchemaExecutionGenerator
implements ExecutionGenerator {
    @Override
    public Map<String, Object> generate(PipelineTemplate template, TemplateConfiguration configuration, TemplatedPipelineRequest request) {
        HashMap<String, Object> pipeline = new HashMap<String, Object>();
        pipeline.put("id", Optional.ofNullable(request.getId()).orElse(Optional.ofNullable(configuration.getPipeline().getPipelineConfigId()).orElse("unknown")));
        pipeline.put("application", configuration.getPipeline().getApplication());
        if (template.getSource() != null) {
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("id", template.getSource());
            source.put("type", "templatedPipeline");
            source.put("version", "v1");
            pipeline.put("source", source);
        }
        if (request.getExecutionId() != null) {
            pipeline.put("executionId", request.getExecutionId());
        }
        pipeline.put("name", Optional.ofNullable(configuration.getPipeline().getName()).orElse("Unnamed Execution"));
        PipelineTemplate.Configuration c = template.getConfiguration();
        if (c.getConcurrentExecutions().isEmpty()) {
            pipeline.put("limitConcurrent", request.isLimitConcurrent());
            pipeline.put("maxConcurrentExecutions", request.getMaxConcurrentExecutions());
            pipeline.put("keepWaitingPipelines", request.isKeepWaitingPipelines());
        } else {
            pipeline.put("limitConcurrent", c.getConcurrentExecutions().getOrDefault("limitConcurrent", request.isLimitConcurrent()));
            pipeline.put("maxConcurrentExecutions", c.getConcurrentExecutions().getOrDefault("maxConcurrentExecutions", request.getMaxConcurrentExecutions()));
            pipeline.put("keepWaitingPipelines", c.getConcurrentExecutions().getOrDefault("keepWaitingPipelines", request.isKeepWaitingPipelines()));
        }
        this.addNotifications(pipeline, template, configuration);
        this.addParameters(pipeline, template, configuration);
        this.addTriggers(pipeline, template, configuration);
        this.addExpectedArtifacts(pipeline, template, configuration, request);
        pipeline.put("stages", template.getStages().stream().map(s -> {
            HashMap<String, Object> stage = new HashMap<String, Object>();
            stage.put("id", UUID.randomUUID().toString());
            stage.put("refId", s.getId());
            stage.put("type", s.getType());
            stage.put("name", s.getName());
            stage.put("requisiteStageRefIds", s.getRequisiteStageRefIds());
            if (s.getPartialDefinitionContext() != null) {
                stage.put("group", String.format("%s: %s", s.getPartialDefinitionContext().getPartialDefinition().getName(), s.getPartialDefinitionContext().getMarkerStage().getName()));
            }
            stage.putAll(s.getConfigAsMap());
            return stage;
        }).collect(Collectors.toList()));
        if (request.getTrigger() != null && !request.getTrigger().isEmpty()) {
            pipeline.put("trigger", request.getTrigger());
        }
        return pipeline;
    }

    private void addNotifications(Map<String, Object> pipeline, PipelineTemplate template, TemplateConfiguration configuration) {
        if (configuration.getConfiguration().getInherit().contains("notifications")) {
            pipeline.put("notifications", TemplateMerge.mergeNamedContent(template.getConfiguration().getNotifications(), configuration.getConfiguration().getNotifications()));
        } else {
            pipeline.put("notifications", Optional.ofNullable(configuration.getConfiguration().getNotifications()).orElse(Collections.emptyList()));
        }
    }

    private void addParameters(Map<String, Object> pipeline, PipelineTemplate template, TemplateConfiguration configuration) {
        if (configuration.getConfiguration().getInherit().contains("parameters")) {
            pipeline.put("parameterConfig", TemplateMerge.mergeNamedContent(template.getConfiguration().getParameters(), configuration.getConfiguration().getParameters()));
        } else {
            pipeline.put("parameterConfig", Optional.ofNullable(configuration.getConfiguration().getParameters()).orElse(Collections.emptyList()));
        }
    }

    private void addTriggers(Map<String, Object> pipeline, PipelineTemplate template, TemplateConfiguration configuration) {
        if (configuration.getConfiguration().getInherit().contains("triggers")) {
            pipeline.put("triggers", TemplateMerge.mergeNamedContent(template.getConfiguration().getTriggers(), configuration.getConfiguration().getTriggers()));
        } else {
            pipeline.put("triggers", Optional.ofNullable(configuration.getConfiguration().getTriggers()).orElse(Collections.emptyList()));
        }
    }

    private void addExpectedArtifacts(Map<String, Object> pipeline, PipelineTemplate template, TemplateConfiguration configuration, TemplatedPipelineRequest request) {
        List<Map<String, Object>> mergedExpectedArtifacts = this.mergeExpectedArtifact(this.emptyListIfNull(configuration.getConfiguration().getExpectedArtifacts()), this.emptyListIfNull(request.getExpectedArtifacts()));
        if (configuration.getConfiguration().getInherit().contains("expectedArtifacts")) {
            mergedExpectedArtifacts = this.mergeExpectedArtifact(this.emptyListIfNull(template.getConfiguration().getExpectedArtifacts()), mergedExpectedArtifacts);
        }
        pipeline.put("expectedArtifacts", mergedExpectedArtifacts);
    }

    private List<? extends Map<String, Object>> emptyListIfNull(List<? extends Map<String, Object>> eas) {
        return Optional.ofNullable(eas).orElse(Collections.emptyList());
    }

    private List<Map<String, Object>> mergeExpectedArtifact(List<? extends Map<String, Object>> eas1, List<? extends Map<String, Object>> eas2) {
        HashMap mergedByName = new HashMap();
        eas1.forEach(artifact -> mergedByName.put(String.valueOf(artifact.get("id")), artifact));
        eas2.forEach(artifact -> mergedByName.put(String.valueOf(artifact.get("id")), artifact));
        return new ArrayList<Map<String, Object>>(mergedByName.values());
    }
}

