/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.converter;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class PipelineTemplateConverter {
    private static final Logger log = LoggerFactory.getLogger(PipelineTemplateConverter.class);

    public String convertToPipelineTemplate(Map<String, Object> pipeline) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
        p.put("schema", "1");
        p.put("id", String.format("%s-%s", pipeline.getOrDefault("application", "spinnaker"), ((String)pipeline.getOrDefault("name", "generatedTemplate")).replaceAll("\\W", "")));
        p.put("metadata", this.generateMetadata(pipeline));
        p.put("protect", false);
        p.put("configuration", this.generateConfiguration(pipeline));
        p.put("variables", new ArrayList());
        p.put("stages", this.convertStages((List)pipeline.get("stages")));
        Representer representer = new Representer();
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setSplitLines(false);
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(), representer, options);
        String output = yaml.dump(p);
        return String.format("%s%s", this.loadTemplateHeader(), output);
    }

    private Map<String, Object> generateMetadata(Map<String, Object> pipeline) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("name", pipeline.getOrDefault("name", "GIVE ME A NAME"));
        m.put("description", pipeline.getOrDefault("description", "GIVE ME A DESCRIPTION"));
        m.put("owner", pipeline.get("lastModifiedBy"));
        m.put("scopes", pipeline.get("application") == null ? new ArrayList() : Collections.singletonList(pipeline.get("application")));
        return m;
    }

    private Map<String, Object> generateConfiguration(Map<String, Object> pipeline) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Comparable<Boolean>> cm = new LinkedHashMap<String, Comparable<Boolean>>();
        cm.put("limitConcurrent", Boolean.valueOf(true));
        cm.put("maxConcurrentExecutions", Integer.valueOf(0));
        m.put("concurrentExecutions", cm);
        m.put("triggers", this.convertTriggers((List)pipeline.get("triggers")));
        m.put("parameters", pipeline.getOrDefault("parameterConfig", new ArrayList()));
        m.put("notifications", this.convertNotifications((List)pipeline.get("notifications")));
        m.put("expectedArtifacts", pipeline.get("expectedArtifacts"));
        return m;
    }

    private List<Map<String, Object>> convertStages(List<Map<String, Object>> stages) {
        return stages.stream().map(s -> {
            List<Object> dependsOn = new ArrayList();
            if (s.containsKey("requisiteStageRefIds") && !((List)s.get("requisiteStageRefIds")).isEmpty()) {
                dependsOn = PipelineTemplateConverter.buildStageRefIds(stages, (List)s.get("requisiteStageRefIds"));
            }
            LinkedHashMap<String, Object> stage = new LinkedHashMap<String, Object>();
            stage.put("id", PipelineTemplateConverter.getStageId((String)s.get("type"), (String)s.get("refId")));
            stage.put("type", s.get("type"));
            stage.put("dependsOn", dependsOn);
            stage.put("name", s.get("name"));
            stage.put("config", PipelineTemplateConverter.scrubStageConfig(s));
            return stage;
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> scrubStageConfig(Map<String, Object> config) {
        LinkedHashMap<String, Object> working = new LinkedHashMap<String, Object>(config);
        working.remove("type");
        working.remove("name");
        working.remove("refId");
        working.remove("requisiteStageRefIds");
        return working;
    }

    private static List<String> buildStageRefIds(List<Map<String, Object>> stages, List<String> requisiteStageRefIds) {
        ArrayList<String> refIds = new ArrayList<String>();
        for (String refId : requisiteStageRefIds) {
            Optional<String> stage = stages.stream().filter(s -> refId.equals(s.get("refId"))).map(s -> PipelineTemplateConverter.getStageId((String)s.get("type"), (String)s.get("refId"))).findFirst();
            stage.ifPresent(refIds::add);
        }
        return refIds;
    }

    private static String getStageId(String type, String refId) {
        return String.format("%s%s", type, refId);
    }

    private List<Map<String, Object>> convertTriggers(List<Map<String, Object>> triggers) {
        if (triggers == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(triggers.size());
        int i = 0;
        for (Map<String, Object> trigger : triggers) {
            trigger.put("name", String.format("unnamed%d", i));
            ++i;
            ret.add(trigger);
        }
        return ret;
    }

    private List<Map<String, Object>> convertNotifications(List<Map<String, Object>> notifications) {
        if (notifications == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(notifications.size());
        int i = 0;
        for (Map<String, Object> notification : notifications) {
            notification.put("name", String.format("%s%d", notification.get("type"), i));
            ++i;
            ret.add(notification);
        }
        return ret;
    }

    private String loadTemplateHeader() {
        InputStream is = this.getClass().getResourceAsStream("/pipelineTemplateHeader.txt");
        if (is == null) {
            log.error("Could not load pipeline template header resource");
            return "# GENERATED BY spinnaker\n";
        }
        return new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
    }
}

