/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.ConditionalStanzaTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.ConfigModuleReplacementTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.ConfigPartialReplacementTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.ConfigStageInjectionTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.DefaultVariableAssignmentTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.PipelineConfigInheritanceTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.RenderTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.StageInheritanceControlTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform.TrimConditionalsTransform;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GraphMutator {
    List<PipelineTemplateVisitor> visitors = new ArrayList<PipelineTemplateVisitor>();

    public GraphMutator(TemplateConfiguration configuration, Renderer renderer, Registry registry, Map<String, Object> trigger) {
        this.visitors.add(new DefaultVariableAssignmentTransform(configuration));
        this.visitors.add(new ConfigModuleReplacementTransform(configuration));
        this.visitors.add(new ConfigPartialReplacementTransform(configuration));
        this.visitors.add(new PipelineConfigInheritanceTransform(configuration));
        this.visitors.add(new RenderTransform(configuration, renderer, registry, trigger));
        this.visitors.add(new ConfigStageInjectionTransform(configuration));
        this.visitors.add(new StageInheritanceControlTransform());
        this.visitors.add(new ConditionalStanzaTransform(configuration, trigger));
        this.visitors.add(new TrimConditionalsTransform());
    }

    public void mutate(PipelineTemplate template) {
        this.visitors.forEach(template::accept);
    }
}

