/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform;

import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.Conditional;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.DefaultRenderContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConditionalStanzaTransform
implements PipelineTemplateVisitor {
    private TemplateConfiguration templateConfiguration;
    private Map<String, Object> trigger;

    public ConditionalStanzaTransform(TemplateConfiguration templateConfiguration, Map<String, Object> trigger) {
        this.templateConfiguration = templateConfiguration;
        this.trigger = trigger;
    }

    @Override
    public void visitPipelineTemplate(PipelineTemplate pipelineTemplate) {
        this.trimConditionals(pipelineTemplate.getStages(), pipelineTemplate);
        this.trimConditionals(this.templateConfiguration.getStages(), pipelineTemplate);
    }

    private <T extends Conditional> void trimConditionals(List<T> stages, PipelineTemplate template) {
        Optional.ofNullable(stages).ifPresent(allStages -> allStages.stream().filter(stage -> stage.getWhen() != null && !stage.getWhen().isEmpty()).forEach(stage -> {
            DefaultRenderContext context = new DefaultRenderContext(this.templateConfiguration.getPipeline().getApplication(), template, this.trigger);
            context.getVariables().putAll(this.templateConfiguration.getPipeline().getVariables());
            for (String conditional : stage.getWhen()) {
                if (Boolean.parseBoolean(conditional)) continue;
                stage.setRemove();
            }
        }));
    }
}

