/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform;

import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.IllegalTemplateConfigurationException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PartialDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStageInjectionTransform
implements PipelineTemplateVisitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private TemplateConfiguration templateConfiguration;

    public ConfigStageInjectionTransform(TemplateConfiguration templateConfiguration) {
        this.templateConfiguration = templateConfiguration;
    }

    @Override
    public void visitPipelineTemplate(PipelineTemplate pipelineTemplate) {
        this.expandStageLoops(pipelineTemplate);
        this.expandStagePartials(pipelineTemplate);
        this.replaceStages(pipelineTemplate);
        this.injectStages(pipelineTemplate);
        this.expandStagePartials(pipelineTemplate);
    }

    private void replaceStages(PipelineTemplate pipelineTemplate) {
        List<StageDefinition> templateStages = pipelineTemplate.getStages();
        for (StageDefinition confStage : this.templateConfiguration.getStages()) {
            for (int i = 0; i < templateStages.size(); ++i) {
                if (!templateStages.get(i).getId().equals(confStage.getId())) continue;
                templateStages.set(i, confStage);
                this.log.debug("Template '{}' stage '{}' replaced by config {}", new Object[]{pipelineTemplate.getId(), confStage.getId(), this.templateConfiguration.getRuntimeId()});
            }
        }
    }

    private void expandStageLoops(PipelineTemplate pipelineTemplate) {
        ArrayList addStages = new ArrayList();
        List<StageDefinition> templateStages = pipelineTemplate.getStages();
        templateStages.stream().filter(StageDefinition::isLooping).forEach(loopingPlaceholder -> {
            List<StageDefinition> stages = loopingPlaceholder.getLoopedStages();
            ConfigStageInjectionTransform.createGraph(stages);
            Map<String, StageDefinition> graph = stages.stream().collect(Collectors.toMap(StageDefinition::getId, i -> i));
            Set<String> leafNodes = ConfigStageInjectionTransform.getLeafNodes(graph);
            stages.stream().filter(s -> s.getDependsOn().isEmpty()).forEach(s -> {
                s.setDependsOn(loopingPlaceholder.getDependsOn());
                s.setRequisiteStageRefIds(loopingPlaceholder.getRequisiteStageRefIds());
            });
            templateStages.stream().filter(s -> s.getDependsOn().contains(loopingPlaceholder.getId())).forEach(s -> {
                s.getDependsOn().remove(loopingPlaceholder.getId());
                s.getDependsOn().addAll(leafNodes);
            });
            templateStages.stream().filter(s -> s.getRequisiteStageRefIds().contains(loopingPlaceholder.getId())).forEach(s -> {
                s.getRequisiteStageRefIds().remove(loopingPlaceholder.getId());
                s.getRequisiteStageRefIds().addAll(leafNodes);
            });
            addStages.addAll(stages);
        });
        templateStages.addAll(addStages);
        templateStages.removeIf(StageDefinition::isLooping);
    }

    private void expandStagePartials(PipelineTemplate pipelineTemplate) {
        ArrayList addStages = new ArrayList();
        List<StageDefinition> templateStages = pipelineTemplate.getStages();
        templateStages.stream().filter(StageDefinition::isPartialType).forEach(partialPlaceholder -> {
            PartialDefinition partial = pipelineTemplate.getPartials().stream().filter(p -> p.getRenderedPartials().containsKey(partialPlaceholder.getId())).findFirst().orElseThrow(() -> new IllegalTemplateConfigurationException(String.format("Could not find rendered partial: %s", partialPlaceholder.getId())));
            List<StageDefinition> stages = partial.getRenderedPartials().get(partialPlaceholder.getId());
            ConfigStageInjectionTransform.createGraph(stages);
            Map<String, StageDefinition> graph = stages.stream().collect(Collectors.toMap(StageDefinition::getId, i -> i));
            Set<String> leafNodes = ConfigStageInjectionTransform.getLeafNodes(graph);
            stages.stream().filter(s -> s.getDependsOn().isEmpty()).forEach(s -> {
                s.setDependsOn(partialPlaceholder.getDependsOn());
                s.setRequisiteStageRefIds(partialPlaceholder.getRequisiteStageRefIds());
            });
            templateStages.stream().filter(s -> s.getDependsOn().contains(partialPlaceholder.getId())).forEach(s -> {
                s.getDependsOn().remove(partialPlaceholder.getId());
                s.getDependsOn().addAll(leafNodes);
            });
            templateStages.stream().filter(s -> s.getRequisiteStageRefIds().contains(partialPlaceholder.getId())).forEach(s -> {
                s.getRequisiteStageRefIds().remove(partialPlaceholder.getId());
                s.getRequisiteStageRefIds().addAll(leafNodes);
            });
            addStages.addAll(stages);
        });
        templateStages.addAll(addStages);
        templateStages.removeIf(StageDefinition::isPartialType);
    }

    private void injectStages(PipelineTemplate pipelineTemplate) {
        List<StageDefinition> initialStages = pipelineTemplate.getStages();
        initialStages.addAll(this.templateConfiguration.getStages().stream().filter(s -> !s.getDependsOn().isEmpty()).collect(Collectors.toList()));
        pipelineTemplate.setStages(ConfigStageInjectionTransform.createGraph(initialStages));
        ConfigStageInjectionTransform.injectStages(pipelineTemplate.getStages(), pipelineTemplate.getStages());
        ConfigStageInjectionTransform.injectStages(this.templateConfiguration.getStages(), pipelineTemplate.getStages());
    }

    private static void dfs(String stageId, Set<StageDefinition> result, Map<String, Status> state, Map<String, StageDefinition> graph, Map<String, Integer> outOrder) {
        state.put(stageId, Status.VISITING);
        StageDefinition stage = graph.get(stageId);
        if (stage == null) {
            state.put(stageId, Status.VISITED);
            return;
        }
        for (String n : stage.getRequisiteStageRefIds()) {
            Status status = state.get(n);
            if (status == Status.VISITING) {
                throw new IllegalTemplateConfigurationException(String.format("Cycle detected in graph (discovered on stage: %s)", stageId));
            }
            if (status == Status.VISITED) continue;
            ConfigStageInjectionTransform.dfs(n, result, state, graph, outOrder);
        }
        result.add(stage);
        state.put(stage.getId(), Status.VISITED);
        stage.getRequisiteStageRefIds().forEach(s -> {
            int order = outOrder.getOrDefault(s, 0);
            outOrder.put((String)s, order + 1);
        });
    }

    private static List<StageDefinition> createGraph(List<StageDefinition> stages) {
        LinkedHashSet sorted = new LinkedHashSet();
        HashMap state = new HashMap();
        stages.forEach(s -> s.setRequisiteStageRefIds(s.getDependsOn()));
        Map<String, StageDefinition> graph = stages.stream().collect(Collectors.toMap(StageDefinition::getId, i -> i));
        graph.forEach((k, v) -> ConfigStageInjectionTransform.dfs(k, sorted, state, graph, new HashMap<String, Integer>()));
        return new ArrayList<StageDefinition>(sorted);
    }

    private static void injectStages(List<StageDefinition> stages, List<StageDefinition> templateStages) {
        for (StageDefinition s : new ArrayList<StageDefinition>(stages)) {
            if (s.getInject() == null || !s.getInject().hasAny()) continue;
            templateStages.removeIf(stage -> stage.getId().equals(s.getId()));
            StageDefinition.InjectionRule rule = s.getInject();
            if (rule.getFirst() != null && rule.getFirst().booleanValue()) {
                ConfigStageInjectionTransform.injectFirst(s, templateStages);
                continue;
            }
            if (rule.getLast() != null && rule.getLast().booleanValue()) {
                ConfigStageInjectionTransform.injectLast(s, templateStages);
                continue;
            }
            if (rule.getBefore() != null) {
                ConfigStageInjectionTransform.injectBefore(s, rule.getBefore(), templateStages);
                continue;
            }
            if (rule.getAfter() != null) {
                ConfigStageInjectionTransform.injectAfter(s, rule.getAfter(), templateStages);
                continue;
            }
            throw new IllegalTemplateConfigurationException(String.format("stage did not have any valid injections defined (id: %s)", s.getId()));
        }
    }

    private static void injectFirst(StageDefinition stage, List<StageDefinition> allStages) {
        if (!allStages.isEmpty()) {
            allStages.forEach(s -> {
                if (s.getRequisiteStageRefIds().isEmpty()) {
                    s.getRequisiteStageRefIds().add(stage.getId());
                }
            });
            allStages.add(0, stage);
        } else {
            allStages.add(stage);
        }
    }

    private static void injectLast(StageDefinition stage, List<StageDefinition> allStages) {
        HashMap outOrder = new HashMap();
        LinkedHashSet sorted = new LinkedHashSet();
        HashMap state = new HashMap();
        Map<String, StageDefinition> graph = allStages.stream().collect(Collectors.toMap(StageDefinition::getId, i -> i));
        graph.keySet().forEach(k -> outOrder.put(k, 0));
        graph.forEach((k, v) -> ConfigStageInjectionTransform.dfs(k, sorted, state, graph, outOrder));
        sorted.stream().filter(i -> (Integer)outOrder.get(i.getId()) == 0).forEach(i -> stage.getRequisiteStageRefIds().add(i.getId()));
        allStages.add(stage);
        graph.put(stage.getId(), stage);
        ConfigStageInjectionTransform.ensureNoCyclesInDAG(allStages, graph);
    }

    private static void injectBefore(StageDefinition stage, List<String> targetIds, List<StageDefinition> allStages) {
        LinkedHashSet<String> targetEdges = new LinkedHashSet<String>();
        TreeSet<Integer> targetIndexes = new TreeSet<Integer>();
        for (String targetId : targetIds) {
            StageDefinition target = ConfigStageInjectionTransform.getInjectionTarget(stage.getId(), targetId, allStages);
            targetEdges.addAll(target.getRequisiteStageRefIds());
            target.getRequisiteStageRefIds().clear();
            target.getRequisiteStageRefIds().add(stage.getId());
            targetIndexes.add(allStages.indexOf(target));
        }
        stage.getRequisiteStageRefIds().addAll(targetEdges);
        allStages.add((Integer)targetIndexes.last(), stage);
        Map<String, StageDefinition> graph = allStages.stream().collect(Collectors.toMap(StageDefinition::getId, i -> i));
        ConfigStageInjectionTransform.ensureNoCyclesInDAG(allStages, graph);
    }

    private static void ensureNoCyclesInDAG(List<StageDefinition> allStages, Map<String, StageDefinition> graph) {
        HashMap state = new HashMap();
        allStages.stream().collect(Collectors.toMap(StageDefinition::getId, i -> i)).forEach((k, v) -> ConfigStageInjectionTransform.dfs(k, new LinkedHashSet<StageDefinition>(), state, graph, new HashMap<String, Integer>()));
    }

    private static void injectAfter(StageDefinition stage, List<String> targetIds, List<StageDefinition> allStages) {
        HashMap outOrder = new HashMap();
        LinkedHashSet sorted = new LinkedHashSet();
        HashMap state = new HashMap();
        Map<String, StageDefinition> graph = allStages.stream().collect(Collectors.toMap(StageDefinition::getId, i -> i));
        graph.forEach((k, v) -> ConfigStageInjectionTransform.dfs(k, sorted, state, graph, outOrder));
        TreeSet<Integer> targetIndexes = new TreeSet<Integer>();
        for (String targetId : targetIds) {
            StageDefinition target = graph.get(targetId);
            if (target == null) {
                throw new IllegalTemplateConfigurationException(String.format("could not inject '%s' stage: unknown target stage id '%s'", stage.getId(), targetId));
            }
            targetIndexes.add(allStages.indexOf(target));
            stage.getRequisiteStageRefIds().add(target.getId());
            Set edges = graph.entrySet().stream().filter(s -> ((StageDefinition)s.getValue()).getRequisiteStageRefIds().contains(targetId)).map(Map.Entry::getValue).collect(Collectors.toSet());
            edges.stream().filter(e -> e.getRequisiteStageRefIds().removeIf(targetId::equals)).forEach(e -> e.getRequisiteStageRefIds().add(stage.getId()));
        }
        allStages.add((Integer)targetIndexes.last() + 1, stage);
        graph.put(stage.getId(), stage);
        ConfigStageInjectionTransform.ensureNoCyclesInDAG(allStages, graph);
    }

    private static StageDefinition getInjectionTarget(String stageId, String targetId, List<StageDefinition> allStages) {
        return allStages.stream().filter(pts -> pts.getId().equals(targetId)).findFirst().orElseThrow(() -> new IllegalTemplateConfigurationException(String.format("could not inject '%s' stage: unknown target stage id '%s'", stageId, targetId)));
    }

    private static Set<String> getLeafNodes(Map<String, StageDefinition> graph) {
        HashMap outOrder = new HashMap();
        LinkedHashSet sorted = new LinkedHashSet();
        HashMap state = new HashMap();
        graph.keySet().forEach(k -> outOrder.put(k, 0));
        graph.forEach((k, v) -> ConfigStageInjectionTransform.dfs(k, sorted, state, graph, outOrder));
        return sorted.stream().filter(i -> (Integer)outOrder.get(i.getId()) == 0).map(StageDefinition::getId).collect(Collectors.toSet());
    }

    private static enum Status {
        VISITING,
        VISITED;

    }
}

