/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform;

import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.IllegalTemplateConfigurationException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultVariableAssignmentTransform
implements PipelineTemplateVisitor {
    TemplateConfiguration templateConfiguration;

    public DefaultVariableAssignmentTransform(TemplateConfiguration templateConfiguration) {
        this.templateConfiguration = templateConfiguration;
    }

    @Override
    public void visitPipelineTemplate(PipelineTemplate pipelineTemplate) {
        List<PipelineTemplate.Variable> pipelineTemplateVariables = pipelineTemplate.getVariables();
        if (pipelineTemplateVariables == null || pipelineTemplateVariables.isEmpty()) {
            return;
        }
        Map<Object, Object> configVars = this.templateConfiguration.getPipeline().getVariables() != null ? this.templateConfiguration.getPipeline().getVariables() : new HashMap();
        pipelineTemplateVariables.stream().filter(templateVar -> !configVars.containsKey(templateVar.getName()) && templateVar.hasDefaultValue()).forEach(templateVar -> configVars.put(templateVar.getName(), templateVar.getDefaultValue()));
        List missingVariables = pipelineTemplateVariables.stream().filter(templateVar -> !configVars.containsKey(templateVar.getName()) && !templateVar.isNullable()).map(PipelineTemplate.Variable::getName).collect(Collectors.toList());
        if (!missingVariables.isEmpty()) {
            throw new IllegalTemplateConfigurationException("Missing variable values for: " + StringUtils.join(missingVariables, (String)", "));
        }
        List wrongNullableErrorMessages = pipelineTemplateVariables.stream().filter(templateVar -> !templateVar.isNullable() && configVars.get(templateVar.getName()) == null).map(var -> String.format("variable '%s' supplied value is null but variable is not nullable\n", var.getName())).collect(Collectors.toList());
        if (!wrongNullableErrorMessages.isEmpty()) {
            throw new IllegalTemplateConfigurationException("Incorrectly defined variable(s): " + StringUtils.join(wrongNullableErrorMessages, (String)", "));
        }
        List wrongTypeErrorMessages = pipelineTemplateVariables.stream().filter(templateVar -> {
            Object actualVar = configVars.get(templateVar.getName());
            String expectedType = templateVar.getType();
            if (expectedType.equalsIgnoreCase("object")) {
                return false;
            }
            if (templateVar.isNullable() && actualVar == null) {
                return false;
            }
            Class<?> actualType = actualVar.getClass();
            return !(this.isInteger((PipelineTemplate.Variable)templateVar, actualVar) || expectedType.equalsIgnoreCase("bool") && actualVar instanceof Boolean || expectedType.equalsIgnoreCase("list") && actualVar instanceof Collection || expectedType.equalsIgnoreCase("string") && actualVar instanceof CharSequence || expectedType.equalsIgnoreCase("float") && (actualVar instanceof Double || actualVar instanceof Float) || expectedType.equalsIgnoreCase(actualType.getSimpleName()));
        }).map(var -> var.getName() + " (expected type '" + var.getType() + "' found type '" + configVars.get(var.getName()).getClass().getSimpleName() + "')").collect(Collectors.toList());
        if (!wrongTypeErrorMessages.isEmpty()) {
            throw new IllegalTemplateConfigurationException("Incorrectly defined variable(s): " + StringUtils.join(wrongTypeErrorMessages, (String)", "));
        }
    }

    private boolean isInteger(PipelineTemplate.Variable templateVar, Object actualVar) {
        boolean instanceOfDouble = actualVar instanceof Double;
        boolean instanceOfFloat = actualVar instanceof Float;
        boolean noDecimal = true;
        if (instanceOfDouble) {
            Double actualDouble = (double)((Double)actualVar);
            noDecimal = actualDouble % 1.0 == 0.0;
        } else if (instanceOfFloat) {
            Float actualFloat = Float.valueOf(((Float)actualVar).floatValue());
            noDecimal = actualFloat.floatValue() % 1.0f == 0.0f;
        }
        String expectedtype = templateVar.getType();
        return expectedtype.equalsIgnoreCase("int") && (actualVar instanceof Integer || noDecimal && instanceOfDouble || noDecimal && instanceOfFloat);
    }
}

