/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform;

import com.google.common.base.Strings;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.IllegalTemplateConfigurationException;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedHashMap;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PartialDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderUtil;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class RenderTransform
implements PipelineTemplateVisitor {
    TemplateConfiguration templateConfiguration;
    Renderer renderer;
    Registry registry;
    Map<String, Object> trigger;
    private final Timer renderTemplateTimer;

    public RenderTransform(TemplateConfiguration templateConfiguration, Renderer renderer, Registry registry, Map<String, Object> trigger) {
        this.templateConfiguration = templateConfiguration;
        this.renderer = renderer;
        this.registry = registry;
        this.trigger = trigger;
        this.renderTemplateTimer = registry.timer("server.renderPipelineTemplate");
    }

    @Override
    public void visitPipelineTemplate(PipelineTemplate pipelineTemplate) {
        long start = this.registry.clock().monotonicTime();
        this.render(pipelineTemplate);
        long end = this.registry.clock().monotonicTime();
        this.renderTemplateTimer.record(end - start, TimeUnit.NANOSECONDS);
    }

    private void render(PipelineTemplate template) {
        RenderContext context = RenderUtil.createDefaultRenderContext(template, this.templateConfiguration, this.trigger);
        this.expandLoops(template.getStages(), context);
        this.expandLoops(this.templateConfiguration.getStages(), context);
        this.renderStages(RenderTransform.filterStages(template.getStages(), false), context, "template");
        this.renderStages(RenderTransform.filterStages(this.templateConfiguration.getStages(), false), context, "configuration");
        this.renderPartials(template.getPartials(), RenderTransform.filterStages(template.getStages(), true), context);
        this.renderPartials(template.getPartials(), RenderTransform.filterStages(this.templateConfiguration.getStages(), true), context);
        this.renderConfigurations(template.getConfiguration().getParameters(), context, "template:configuration.parameters");
        this.renderConfigurations(this.templateConfiguration.getConfiguration().getParameters(), context, "configuration:configuration.parameters");
        this.renderConfigurations(template.getConfiguration().getTriggers(), context, "template:configuration.triggers");
        this.renderConfigurations(this.templateConfiguration.getConfiguration().getTriggers(), context, "configuration:configuration.triggers");
        this.renderConfigurations(template.getConfiguration().getNotifications(), context, "template:configuration.notifications");
        this.renderConfigurations(this.templateConfiguration.getConfiguration().getNotifications(), context, "configuration:configuration.notifications");
    }

    private void expandLoops(List<StageDefinition> stages, RenderContext context) {
        for (StageDefinition stage : RenderTransform.loopingStages(stages)) {
            Object loopValue;
            try {
                loopValue = RenderUtil.deepRender(this.renderer, stage.getLoopWith(), context);
            }
            catch (TemplateRenderException e) {
                throw TemplateRenderException.fromError(new Errors.Error().withMessage("Failed rendering loopWith value").withLocation(context.getLocation()), (Throwable)((Object)e));
            }
            if (!(loopValue instanceof Collection)) {
                throw TemplateRenderException.fromError(new Errors.Error().withMessage("Rendered loopWith value must be a list").withCause("Received type " + loopValue.getClass().toString()).withLocation(context.getLocation()));
            }
            int index = 0;
            for (Object value : (Collection)loopValue) {
                StageDefinition expandedStage = this.wrapClone(stage);
                expandedStage.getLoopContext().put("value", value);
                expandedStage.setLoopWith(null);
                if (stage.getId().contains("{{") && stage.getId().contains("}}")) {
                    RenderContext loopedContext = context.copy();
                    loopedContext.getVariables().put("templateLoop", expandedStage.getLoopContext());
                    expandedStage.setId(this.renderer.render(stage.getId(), loopedContext));
                } else {
                    expandedStage.setId(stage.getId() + index);
                }
                stage.getLoopedStages().add(expandedStage);
                ++index;
            }
        }
    }

    private void renderStages(List<StageDefinition> stages, RenderContext context, String locationNamespace) {
        if (stages == null) {
            return;
        }
        for (StageDefinition stage : stages) {
            if (stage.isPartialType()) continue;
            context.setLocation(String.format("%s:stages.%s", locationNamespace, stage.getId()));
            this.renderStage(stage, context, locationNamespace);
        }
    }

    private void renderStage(StageDefinition stage, RenderContext context, String locationNamespace) {
        Object rendered;
        if (stage.isLooping()) {
            for (StageDefinition loopedStage : stage.getLoopedStages()) {
                RenderContext loopContext = context.copy();
                loopContext.getVariables().put("templateLoop", loopedStage.getLoopContext());
                this.renderStage(loopedStage, loopContext, locationNamespace);
            }
            return;
        }
        try {
            rendered = RenderUtil.deepRender(this.renderer, stage.getConfig(), context);
        }
        catch (TemplateRenderException e) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("Failed rendering stage").withLocation(context.getLocation()), (Throwable)((Object)e));
        }
        if (!(rendered instanceof Map)) {
            throw new IllegalTemplateConfigurationException(new Errors.Error().withMessage("A stage's rendered config must be a map").withCause("Received type " + rendered.getClass().toString()).withLocation(context.getLocation()));
        }
        stage.setConfig((Map)rendered);
        stage.setName(this.renderStageProperty(stage.getName(), context, RenderTransform.getStagePropertyLocation(locationNamespace, stage.getId(), "name")));
        stage.setComments(this.renderStageProperty(stage.getComments(), context, RenderTransform.getStagePropertyLocation(locationNamespace, stage.getId(), "comments")));
        if (stage.getWhen() != null) {
            stage.setWhen(stage.getWhen().stream().map(w -> this.renderStageProperty((String)w, context, RenderTransform.getStagePropertyLocation(locationNamespace, stage.getId(), "when"))).collect(Collectors.toList()));
        }
    }

    private String renderStageProperty(String input, RenderContext context, String location) {
        Object result;
        try {
            result = RenderUtil.deepRender(this.renderer, input, context);
        }
        catch (TemplateRenderException e) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("Failed rendering stage property").withLocation(location), (Throwable)((Object)e));
        }
        return result == null ? null : result.toString();
    }

    private static String getStagePropertyLocation(String namespace, String stageId, String propertyName) {
        return String.format("%s:stages.%s.%s", namespace, stageId, propertyName);
    }

    private static List<StageDefinition> filterStages(List<StageDefinition> stages, boolean partialsOnly) {
        return stages.stream().filter(s -> partialsOnly == s.isPartialType()).collect(Collectors.toList());
    }

    private static List<StageDefinition> loopingStages(List<StageDefinition> stages) {
        return stages.stream().filter(it -> !Strings.isNullOrEmpty((String)it.getLoopWith())).collect(Collectors.toList());
    }

    private void renderPartials(List<PartialDefinition> partials, List<StageDefinition> stages, RenderContext context) {
        for (StageDefinition stage : stages) {
            String partialId = stage.getPartialId();
            if (partialId == null) {
                throw TemplateRenderException.fromError(new Errors.Error().withMessage("Stage with partial type has malformed ID format").withCause(String.format("Expected 'partial:PARTIAL_ID' got '%s'", stage.getType())).withLocation(String.format("template:stages.%s", stage.getId())));
            }
            PartialDefinition partial = partials.stream().filter(p -> p.getId().equals(partialId)).findFirst().orElseThrow(() -> TemplateRenderException.fromError(new Errors.Error().withMessage("Unable to find Partial by ID: " + partialId).withLocation(String.format("template:stages.%s", stage.getId()))));
            if (stage.isLooping()) {
                for (StageDefinition loopedStage : stage.getLoopedStages()) {
                    RenderContext loopedContext = context.copy();
                    loopedContext.getVariables().put("templateLoop", loopedStage.getLoopContext());
                    this.renderPartial(partial, loopedStage, loopedContext);
                }
                continue;
            }
            this.renderPartial(partial, stage, context);
        }
    }

    private void renderPartial(PartialDefinition partial, StageDefinition stage, RenderContext context) {
        RenderContext partialContext = context.copy();
        partialContext.setLocation(String.format("template:stages.%s", stage.getId()));
        this.renderStage(stage, partialContext, "template");
        partialContext.getVariables().putAll(stage.getConfigAsMap());
        partialContext.setLocation(String.format("partial:%s.%s", stage.getId(), partial.getId()));
        ArrayList<StageDefinition> renderedStages = new ArrayList<StageDefinition>();
        for (StageDefinition partialStage : partial.getStages()) {
            if (partialStage.isPartialType()) {
                throw TemplateRenderException.fromError(new Errors.Error().withMessage("Recursive partials support is not currently implemented").withLocation(String.format("partial:%s", partial.getId())));
            }
            StageDefinition renderedStage = this.wrapClone(partialStage);
            renderedStage.setPartialDefinitionContext(new StageDefinition.PartialDefinitionContext(partial, stage));
            renderedStage.setId(String.format("%s.%s", stage.getId(), renderedStage.getId()));
            renderedStage.setDependsOn(renderedStage.getDependsOn().stream().map(d -> String.format("%s.%s", stage.getId(), d)).collect(Collectors.toSet()));
            this.renderStage(renderedStage, partialContext, String.format("partial:%s.%s", stage.getId(), partial.getId()));
            renderedStages.add(renderedStage);
        }
        partial.getRenderedPartials().put(stage.getId(), renderedStages);
    }

    private void renderConfigurations(List<NamedHashMap> configurations, RenderContext context, String location) {
        if (configurations == null) {
            return;
        }
        for (Map map : configurations) {
            for (Map.Entry entry : map.entrySet()) {
                try {
                    entry.setValue(RenderUtil.deepRender(this.renderer, entry.getValue(), context));
                }
                catch (TemplateRenderException e) {
                    throw TemplateRenderException.fromError(new Errors.Error().withMessage("Failed rendering configuration property").withLocation(location), (Throwable)((Object)e));
                }
            }
        }
    }

    private StageDefinition wrapClone(StageDefinition stage) {
        try {
            return (StageDefinition)stage.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TemplateRenderException("StageDefinition clone unsupported", e);
        }
    }
}

