/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.transform;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.IllegalTemplateConfigurationException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.MapMerge;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.StageDefinition;
import java.util.Collection;
import java.util.Map;

public class StageInheritanceControlTransform
implements PipelineTemplateVisitor {
    @Override
    public void visitPipelineTemplate(PipelineTemplate pipelineTemplate) {
        pipelineTemplate.getStages().stream().filter(s -> s.getInheritanceControl() != null).forEach(s -> {
            DocumentContext dc = JsonPath.parse((Object)s.getConfig());
            s.getInheritanceControl().getMerge().forEach(r -> StageInheritanceControlTransform.merge(dc, r));
            s.getInheritanceControl().getReplace().forEach(r -> StageInheritanceControlTransform.replace(dc, r));
            s.getInheritanceControl().getRemove().forEach(r -> dc.delete(r.getPath(), new Predicate[0]));
        });
    }

    private static void merge(DocumentContext dc, StageDefinition.InheritanceControl.Rule rule) {
        Object oldValue = dc.read(rule.getPath(), new Predicate[0]);
        if (oldValue instanceof Collection) {
            if (!(rule.getValue() instanceof Collection)) {
                throw new IllegalTemplateConfigurationException("cannot merge non-collection value into collection");
            }
            ((Collection)oldValue).addAll((Collection)rule.getValue());
            dc.set(rule.getPath(), oldValue, new Predicate[0]);
        } else if (oldValue instanceof Map) {
            if (!(rule.getValue() instanceof Map)) {
                throw new IllegalTemplateConfigurationException("cannot merge non-map value into map");
            }
            Map<String, Object> merged = MapMerge.merge((Map)oldValue, (Map)rule.getValue());
            dc.set(rule.getPath(), merged, new Predicate[0]);
        } else {
            throw new IllegalTemplateConfigurationException("merge inheritance control must be given a list or map value: " + rule.getPath());
        }
    }

    private static void replace(DocumentContext dc, StageDefinition.InheritanceControl.Rule rule) {
        Object oldValue = dc.read(rule.getPath(), new Predicate[0]);
        if (oldValue instanceof Collection && !(rule.getValue() instanceof Collection)) {
            throw new IllegalTemplateConfigurationException("cannot replace collection value with non-collection value");
        }
        if (oldValue instanceof Map && !(rule.getValue() instanceof Map)) {
            throw new IllegalTemplateConfigurationException("cannot replace map value with non-map value");
        }
        dc.set(rule.getPath(), rule.getValue(), new Predicate[0]);
    }
}

