/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.v2.transform;

import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.IllegalTemplateConfigurationException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.V2PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2TemplateConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2ConfigStageInjectionTransform
implements V2PipelineTemplateVisitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private V2TemplateConfiguration templateConfiguration;

    public V2ConfigStageInjectionTransform(V2TemplateConfiguration templateConfiguration) {
        this.templateConfiguration = templateConfiguration;
    }

    @Override
    public void visitPipelineTemplate(V2PipelineTemplate pipelineTemplate) {
        this.replaceStages(pipelineTemplate);
        this.injectStages(pipelineTemplate);
    }

    private void replaceStages(V2PipelineTemplate pipelineTemplate) {
        List<V2StageDefinition> templateStages = pipelineTemplate.getStages();
        for (V2StageDefinition confStage : this.templateConfiguration.getStages()) {
            for (int i = 0; i < templateStages.size(); ++i) {
                if (!templateStages.get(i).getRefId().equals(confStage.getRefId())) continue;
                templateStages.set(i, confStage);
                pipelineTemplate.setStages(templateStages);
                this.log.debug("Template '{}' stage '{}' replaced by config {}", new Object[]{pipelineTemplate.getId(), confStage.getRefId(), this.templateConfiguration.getRuntimeId()});
            }
        }
    }

    private void injectStages(V2PipelineTemplate pipelineTemplate) {
        List<V2StageDefinition> initialStages = pipelineTemplate.getStages();
        initialStages.addAll(this.templateConfiguration.getStages().stream().filter(s -> !s.getRequisiteStageRefIds().isEmpty()).collect(Collectors.toList()));
        pipelineTemplate.setStages(V2ConfigStageInjectionTransform.createGraph(initialStages));
        List<V2StageDefinition> templateInjectStages = V2ConfigStageInjectionTransform.injectStages(pipelineTemplate.getStages(), pipelineTemplate.getStages());
        List<V2StageDefinition> configInjectStages = V2ConfigStageInjectionTransform.injectStages(this.templateConfiguration.getStages(), templateInjectStages);
        pipelineTemplate.setStages(configInjectStages);
    }

    private static void dfs(String stageId, Set<V2StageDefinition> result, Map<String, Status> state, Map<String, V2StageDefinition> graph, Map<String, Integer> outOrder) {
        state.put(stageId, Status.VISITING);
        V2StageDefinition stage = graph.get(stageId);
        if (stage == null) {
            state.put(stageId, Status.VISITED);
            return;
        }
        for (String n : stage.getRequisiteStageRefIds()) {
            Status status = state.get(n);
            if (status == Status.VISITING) {
                throw new IllegalTemplateConfigurationException(String.format("Cycle detected in graph (discovered on stage: %s)", stageId));
            }
            if (status == Status.VISITED) continue;
            V2ConfigStageInjectionTransform.dfs(n, result, state, graph, outOrder);
        }
        result.add(stage);
        state.put(stage.getRefId(), Status.VISITED);
        stage.getRequisiteStageRefIds().forEach(s -> {
            int order = outOrder.getOrDefault(s, 0);
            outOrder.put((String)s, order + 1);
        });
    }

    private static List<V2StageDefinition> createGraph(List<V2StageDefinition> stages) {
        LinkedHashSet sorted = new LinkedHashSet();
        HashMap state = new HashMap();
        Map<String, V2StageDefinition> graph = stages.stream().collect(Collectors.toMap(V2StageDefinition::getRefId, i -> i));
        graph.forEach((k, v) -> V2ConfigStageInjectionTransform.dfs(k, sorted, state, graph, new HashMap<String, Integer>()));
        return new ArrayList<V2StageDefinition>(sorted);
    }

    private static List<V2StageDefinition> injectStages(List<V2StageDefinition> stages, List<V2StageDefinition> templateStages) {
        for (V2StageDefinition s : new ArrayList<V2StageDefinition>(stages)) {
            if (s.getInject() == null || !s.getInject().hasAny()) continue;
            templateStages.removeIf(stage -> stage.getRefId().equals(s.getRefId()));
            StageDefinition.InjectionRule rule = s.getInject();
            if (rule.getFirst() != null && rule.getFirst().booleanValue()) {
                V2ConfigStageInjectionTransform.injectFirst(s, templateStages);
                continue;
            }
            if (rule.getLast() != null && rule.getLast().booleanValue()) {
                V2ConfigStageInjectionTransform.injectLast(s, templateStages);
                continue;
            }
            if (rule.getBefore() != null) {
                V2ConfigStageInjectionTransform.injectBefore(s, rule.getBefore(), templateStages);
                continue;
            }
            if (rule.getAfter() != null) {
                V2ConfigStageInjectionTransform.injectAfter(s, rule.getAfter(), templateStages);
                continue;
            }
            throw new IllegalTemplateConfigurationException(String.format("stage did not have any valid injections defined (id: %s)", s.getRefId()));
        }
        return templateStages;
    }

    private static void injectFirst(V2StageDefinition stage, List<V2StageDefinition> allStages) {
        if (!allStages.isEmpty()) {
            allStages.forEach(s -> {
                if (s.getRequisiteStageRefIds().isEmpty()) {
                    s.getRequisiteStageRefIds().add(stage.getRefId());
                }
            });
            allStages.add(0, stage);
        } else {
            allStages.add(stage);
        }
    }

    private static void injectLast(V2StageDefinition stage, List<V2StageDefinition> allStages) {
        HashMap outOrder = new HashMap();
        LinkedHashSet sorted = new LinkedHashSet();
        HashMap state = new HashMap();
        Map<String, V2StageDefinition> graph = allStages.stream().collect(Collectors.toMap(V2StageDefinition::getRefId, i -> i));
        graph.keySet().forEach(k -> outOrder.put(k, 0));
        graph.forEach((k, v) -> V2ConfigStageInjectionTransform.dfs(k, sorted, state, graph, outOrder));
        sorted.stream().filter(i -> (Integer)outOrder.get(i.getRefId()) == 0).forEach(i -> stage.getRequisiteStageRefIds().add(i.getRefId()));
        allStages.add(stage);
        graph.put(stage.getRefId(), stage);
        V2ConfigStageInjectionTransform.ensureNoCyclesInDAG(allStages, graph);
    }

    private static void injectBefore(V2StageDefinition stage, List<String> targetIds, List<V2StageDefinition> allStages) {
        LinkedHashSet<String> targetEdges = new LinkedHashSet<String>();
        TreeSet<Integer> targetIndexes = new TreeSet<Integer>();
        for (String targetId : targetIds) {
            V2StageDefinition target = V2ConfigStageInjectionTransform.getInjectionTarget(stage.getRefId(), targetId, allStages);
            targetEdges.addAll(target.getRequisiteStageRefIds());
            target.getRequisiteStageRefIds().clear();
            target.getRequisiteStageRefIds().add(stage.getRefId());
            targetIndexes.add(allStages.indexOf(target));
        }
        stage.getRequisiteStageRefIds().addAll(targetEdges);
        allStages.add((Integer)targetIndexes.last(), stage);
        Map<String, V2StageDefinition> graph = allStages.stream().collect(Collectors.toMap(V2StageDefinition::getRefId, i -> i));
        V2ConfigStageInjectionTransform.ensureNoCyclesInDAG(allStages, graph);
    }

    private static void ensureNoCyclesInDAG(List<V2StageDefinition> allStages, Map<String, V2StageDefinition> graph) {
        HashMap state = new HashMap();
        allStages.stream().collect(Collectors.toMap(V2StageDefinition::getRefId, i -> i)).forEach((k, v) -> V2ConfigStageInjectionTransform.dfs(k, new LinkedHashSet<V2StageDefinition>(), state, graph, new HashMap<String, Integer>()));
    }

    private static void injectAfter(V2StageDefinition stage, List<String> targetIds, List<V2StageDefinition> allStages) {
        HashMap outOrder = new HashMap();
        LinkedHashSet sorted = new LinkedHashSet();
        HashMap state = new HashMap();
        Map<String, V2StageDefinition> graph = allStages.stream().collect(Collectors.toMap(V2StageDefinition::getRefId, i -> i));
        graph.forEach((k, v) -> V2ConfigStageInjectionTransform.dfs(k, sorted, state, graph, outOrder));
        TreeSet<Integer> targetIndexes = new TreeSet<Integer>();
        for (String targetId : targetIds) {
            V2StageDefinition target = graph.get(targetId);
            if (target == null) {
                throw new IllegalTemplateConfigurationException(String.format("could not inject '%s' stage: unknown target stage id '%s'", stage.getRefId(), targetId));
            }
            targetIndexes.add(allStages.indexOf(target));
            stage.getRequisiteStageRefIds().add(target.getRefId());
            Set edges = graph.entrySet().stream().filter(s -> ((V2StageDefinition)s.getValue()).getRequisiteStageRefIds().contains(targetId)).map(Map.Entry::getValue).collect(Collectors.toSet());
            edges.stream().filter(e -> e.getRequisiteStageRefIds().removeIf(targetId::equals)).forEach(e -> e.getRequisiteStageRefIds().add(stage.getRefId()));
        }
        allStages.add((Integer)targetIndexes.last() + 1, stage);
        graph.put(stage.getRefId(), stage);
        V2ConfigStageInjectionTransform.ensureNoCyclesInDAG(allStages, graph);
    }

    private static V2StageDefinition getInjectionTarget(String stageId, String targetId, List<V2StageDefinition> allStages) {
        return allStages.stream().filter(pts -> pts.getRefId().equals(targetId)).findFirst().orElseThrow(() -> new IllegalTemplateConfigurationException(String.format("could not inject '%s' stage: unknown target stage id '%s'", stageId, targetId)));
    }

    private static enum Status {
        VISITING,
        VISITED;

    }
}

