/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.graph.v2.transform;

import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.IllegalTemplateConfigurationException;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.PipelineMissingTemplateVariabledException;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.V2PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2TemplateConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2DefaultVariableAssignmentTransform
implements V2PipelineTemplateVisitor {
    private static final Logger log = LoggerFactory.getLogger(V2DefaultVariableAssignmentTransform.class);
    private V2TemplateConfiguration templateConfiguration;

    public V2DefaultVariableAssignmentTransform(V2TemplateConfiguration templateConfiguration) {
        this.templateConfiguration = templateConfiguration;
    }

    @Override
    public void visitPipelineTemplate(V2PipelineTemplate pipelineTemplate) {
        List<V2PipelineTemplate.Variable> pipelineTemplateVariables = pipelineTemplate.getVariables();
        if (pipelineTemplateVariables == null || pipelineTemplateVariables.isEmpty()) {
            return;
        }
        HashMap configVars = this.templateConfiguration.getVariables() != null ? V2DefaultVariableAssignmentTransform.configurationVariables(pipelineTemplateVariables, this.templateConfiguration.getVariables()) : new HashMap();
        pipelineTemplateVariables.stream().filter(templateVar -> !configVars.containsKey(templateVar.getName()) && templateVar.hasDefaultValue()).forEach(templateVar -> configVars.put(templateVar.getName(), templateVar.getDefaultValue()));
        List missingVariables = pipelineTemplateVariables.stream().filter(templateVar -> !configVars.containsKey(templateVar.getName()) && !templateVar.isNullable()).map(V2PipelineTemplate.Variable::getName).collect(Collectors.toList());
        if (!missingVariables.isEmpty()) {
            throw new PipelineMissingTemplateVariabledException("Missing variable values for: " + StringUtils.join(missingVariables, (String)", "));
        }
        List wrongNullableErrorMessages = pipelineTemplateVariables.stream().filter(templateVar -> !templateVar.isNullable() && configVars.get(templateVar.getName()) == null).map(var -> String.format("variable '%s' supplied value is null but variable is not nullable\n", var.getName())).collect(Collectors.toList());
        if (!wrongNullableErrorMessages.isEmpty()) {
            throw new IllegalTemplateConfigurationException("Incorrectly defined variable(s): " + StringUtils.join(wrongNullableErrorMessages, (String)", "));
        }
        List wrongTypeErrorMessages = pipelineTemplateVariables.stream().filter(templateVar -> {
            Object actualVar = configVars.get(templateVar.getName());
            String expectedType = templateVar.getType();
            if (expectedType.equalsIgnoreCase("object")) {
                return false;
            }
            if (templateVar.isNullable() && actualVar == null) {
                return false;
            }
            Class<?> actualType = actualVar.getClass();
            return !(this.isInteger((V2PipelineTemplate.Variable)templateVar, actualVar) || expectedType.equalsIgnoreCase("bool") && actualVar instanceof Boolean || expectedType.equalsIgnoreCase("list") && actualVar instanceof Collection || expectedType.equalsIgnoreCase("string") && actualVar instanceof CharSequence || expectedType.equalsIgnoreCase("float") && (actualVar instanceof Double || actualVar instanceof Float) || expectedType.equalsIgnoreCase(actualType.getSimpleName()));
        }).map(var -> var.getName() + " (expected type '" + var.getType() + "' found type '" + configVars.get(var.getName()).getClass().getSimpleName() + "')").collect(Collectors.toList());
        if (!wrongTypeErrorMessages.isEmpty()) {
            throw new IllegalTemplateConfigurationException("Incorrectly defined variable(s): " + StringUtils.join(wrongTypeErrorMessages, (String)", "));
        }
    }

    private boolean isInteger(V2PipelineTemplate.Variable templateVar, Object actualVar) {
        boolean instanceOfDouble = actualVar instanceof Double;
        boolean instanceOfFloat = actualVar instanceof Float;
        boolean noDecimal = true;
        if (instanceOfDouble) {
            Double actualDouble = (double)((Double)actualVar);
            noDecimal = actualDouble % 1.0 == 0.0;
        } else if (instanceOfFloat) {
            Float actualFloat = Float.valueOf(((Float)actualVar).floatValue());
            noDecimal = actualFloat.floatValue() % 1.0f == 0.0f;
        }
        String expectedtype = templateVar.getType();
        return expectedtype.equalsIgnoreCase("int") && (actualVar instanceof Integer || noDecimal && instanceOfDouble || noDecimal && instanceOfFloat);
    }

    public static Map<String, Object> configurationVariables(final List<V2PipelineTemplate.Variable> pipelineTemplateVariables, Map<String, Object> configVariables) {
        List templateVariableNames = pipelineTemplateVariables.stream().map(var -> var.getName()).collect(Collectors.toList());
        final Map<String, Object> configVars = configVariables.entrySet().stream().filter(configVar -> templateVariableNames.contains(configVar.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List variablesNotInPipelineWithDefaultValue = templateVariableNames.stream().filter(templateVariableName -> !configVars.containsKey(templateVariableName)).filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return pipelineTemplateVariables.stream().filter(pipelineTemplateVariable -> pipelineTemplateVariable.getName().equals(s) && pipelineTemplateVariable.hasDefaultValue()).collect(Collectors.toList()).size() > 0;
            }
        }).collect(Collectors.toList());
        if (variablesNotInPipelineWithDefaultValue.size() > 0) {
            variablesNotInPipelineWithDefaultValue.stream().forEach(new Consumer<String>(){

                @Override
                public void accept(String s) {
                    V2PipelineTemplate.Variable templateVariable = pipelineTemplateVariables.stream().filter(pipelineTemplateVariable -> pipelineTemplateVariable.getName().equals(s)).findFirst().get();
                    configVars.put(templateVariable.getName(), templateVariable.getDefaultValue());
                }
            });
        }
        return configVars;
    }
}

