/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.Handler;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.HandlerChain;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.PipelineTemplateContext;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.PipelineTemplateSchemaContext;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.TemplateLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.TemplateMerge;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.handler.V1PipelineTemplateContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.handler.V1TemplateLoaderHandler;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedHashMap;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.DefaultRenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderUtil;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/handler/V1TemplateLoaderHandler;", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/Handler;", "templateLoader", "Lcom/netflix/spinnaker/orca/pipelinetemplate/loader/TemplateLoader;", "renderer", "Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/render/Renderer;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/netflix/spinnaker/orca/pipelinetemplate/loader/TemplateLoader;Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/render/Renderer;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "handle", "", "chain", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/HandlerChain;", "context", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/PipelineTemplateContext;", "renderTemplateVariables", "renderContext", "Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/render/RenderContext;", "pipelineTemplate", "Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/model/PipelineTemplate;", "setTemplateSourceWithJinja", "tc", "Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/model/TemplateConfiguration;", "trigger", "", "", "", "orca-pipelinetemplate"})
public final class V1TemplateLoaderHandler
implements Handler {
    private final TemplateLoader templateLoader;
    private final Renderer renderer;
    private final ObjectMapper objectMapper;

    @Override
    public void handle(@NotNull HandlerChain chain, @NotNull PipelineTemplateContext context) {
        RenderContext renderContext;
        TemplateConfiguration config;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TemplateConfiguration templateConfiguration = config = (TemplateConfiguration)this.objectMapper.convertValue(context.getRequest().getConfig(), TemplateConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)templateConfiguration, (String)"config");
        TemplateConfiguration.PipelineConfiguration pipelineConfiguration = templateConfiguration.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineConfiguration, (String)"config.configuration");
        List<NamedHashMap> list = pipelineConfiguration.getNotifications();
        List list2 = context.getRequest().getNotifications();
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        list.addAll(list3);
        Boolean bl2 = context.getRequest().getPlan();
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"context.getRequest().plan");
        if (bl2.booleanValue() && context.getRequest().getTemplate() != null) {
            PipelineTemplate template = (PipelineTemplate)this.objectMapper.convertValue(context.getRequest().getTemplate(), PipelineTemplate.class);
            List<PipelineTemplate> templates = this.templateLoader.load(template);
            PipelineTemplate pipelineTemplate = TemplateMerge.merge(templates);
            Intrinsics.checkNotNullExpressionValue((Object)pipelineTemplate, (String)"TemplateMerge.merge(templates)");
            context.setSchemaContext((PipelineTemplateSchemaContext)new V1PipelineTemplateContext(config, pipelineTemplate));
            return;
        }
        Map trigger = TypeIntrinsics.asMutableMap(context.getRequest().getTrigger());
        this.setTemplateSourceWithJinja(config, trigger);
        PipelineTemplate template = null;
        TemplateConfiguration.PipelineDefinition pipelineDefinition = config.getPipeline();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineDefinition, (String)"config.pipeline");
        if (pipelineDefinition.getTemplate() == null) {
            PipelineTemplate pipelineTemplate = new PipelineTemplate();
            boolean bl3 = false;
            boolean bl4 = false;
            PipelineTemplate $this$apply = pipelineTemplate;
            boolean bl5 = false;
            TemplateConfiguration.PipelineDefinition pipelineDefinition2 = config.getPipeline();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineDefinition2, (String)"config.pipeline");
            $this$apply.setVariables(pipelineDefinition2.getVariables().entrySet().stream().map(handle.1.1.INSTANCE).collect(Collectors.toList()));
            template = pipelineTemplate;
        } else {
            TemplateConfiguration.PipelineDefinition pipelineDefinition3 = config.getPipeline();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineDefinition3, (String)"config.pipeline");
            List<PipelineTemplate> templates = this.templateLoader.load(pipelineDefinition3.getTemplate());
            PipelineTemplate pipelineTemplate = TemplateMerge.merge(templates);
            Intrinsics.checkNotNullExpressionValue((Object)pipelineTemplate, (String)"TemplateMerge.merge(templates)");
            template = pipelineTemplate;
            if (template.getSource() == null) {
                TemplateConfiguration.PipelineDefinition pipelineDefinition4 = config.getPipeline();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineDefinition4, (String)"config.pipeline");
                TemplateConfiguration.TemplateSource templateSource = pipelineDefinition4.getTemplate();
                Intrinsics.checkNotNullExpressionValue((Object)templateSource, (String)"config.pipeline.template");
                template.setSource(templateSource.getSource());
            }
        }
        RenderContext renderContext2 = renderContext = RenderUtil.createDefaultRenderContext(template, config, trigger);
        Intrinsics.checkNotNullExpressionValue((Object)renderContext2, (String)"renderContext");
        this.renderTemplateVariables(renderContext2, template);
        context.setSchemaContext((PipelineTemplateSchemaContext)new V1PipelineTemplateContext(config, template));
    }

    private final void renderTemplateVariables(RenderContext renderContext, PipelineTemplate pipelineTemplate) {
        if (pipelineTemplate.getVariables() == null) {
            return;
        }
        List<PipelineTemplate.Variable> list = pipelineTemplate.getVariables();
        Intrinsics.checkNotNullExpressionValue(list, (String)"pipelineTemplate.variables");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PipelineTemplate.Variable v = (PipelineTemplate.Variable)element$iv;
            boolean bl = false;
            PipelineTemplate.Variable variable = v;
            Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"v");
            Object value = variable.getDefaultValue();
            if (v.isNullable() && value == null) {
                renderContext.getVariables().putIfAbsent(v.getName(), v.getDefaultValue());
                continue;
            }
            if (value == null || !(value instanceof String)) continue;
            v.setDefaultValue(this.renderer.renderGraph(value.toString(), renderContext));
            renderContext.getVariables().putIfAbsent(v.getName(), v.getDefaultValue());
        }
    }

    private final void setTemplateSourceWithJinja(TemplateConfiguration tc, Map<String, Object> trigger) {
        block3: {
            block2: {
                if (trigger == null) break block2;
                TemplateConfiguration.PipelineDefinition pipelineDefinition = tc.getPipeline();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineDefinition, (String)"tc.pipeline");
                if (pipelineDefinition.getTemplate() != null) break block3;
            }
            return;
        }
        TemplateConfiguration.PipelineDefinition pipelineDefinition = tc.getPipeline();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineDefinition, (String)"tc.pipeline");
        DefaultRenderContext context = new DefaultRenderContext(pipelineDefinition.getApplication(), null, trigger);
        TemplateConfiguration.PipelineDefinition pipelineDefinition2 = tc.getPipeline();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineDefinition2, (String)"tc.pipeline");
        TemplateConfiguration.TemplateSource templateSource = pipelineDefinition2.getTemplate();
        Intrinsics.checkNotNullExpressionValue((Object)templateSource, (String)"tc.pipeline.template");
        TemplateConfiguration.PipelineDefinition pipelineDefinition3 = tc.getPipeline();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineDefinition3, (String)"tc.pipeline");
        TemplateConfiguration.TemplateSource templateSource2 = pipelineDefinition3.getTemplate();
        Intrinsics.checkNotNullExpressionValue((Object)templateSource2, (String)"tc.pipeline.template");
        templateSource.setSource(this.renderer.render(templateSource2.getSource(), context));
    }

    public V1TemplateLoaderHandler(@NotNull TemplateLoader templateLoader, @NotNull Renderer renderer, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)templateLoader, (String)"templateLoader");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.templateLoader = templateLoader;
        this.renderer = renderer;
        this.objectMapper = objectMapper;
    }
}

