/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.handler.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.Handler;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.HandlerChain;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.PipelineTemplateContext;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.v2.V2PipelineTemplateContext;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.v2.V2TemplateLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.v2.V2DefaultRenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.v2.V2RenderUtil;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2TemplateConfiguration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class V2TemplateLoaderHandler
implements Handler {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private V2TemplateLoader templateLoader;
    private ContextParameterProcessor contextParameterProcessor;
    private ObjectMapper objectMapper;

    public V2TemplateLoaderHandler(V2TemplateLoader templateLoader, ContextParameterProcessor contextParameterProcessor, ObjectMapper objectMapper) {
        this.templateLoader = templateLoader;
        this.contextParameterProcessor = contextParameterProcessor;
        this.objectMapper = objectMapper;
    }

    @Override
    public void handle(@NotNull HandlerChain chain, @NotNull PipelineTemplateContext context) {
        V2TemplateConfiguration config = (V2TemplateConfiguration)this.objectMapper.convertValue(context.getRequest().getConfig(), V2TemplateConfiguration.class);
        Map<String, Object> trigger = context.getRequest().getTrigger();
        this.renderPipelineTemplateSource(config, trigger);
        V2PipelineTemplate template = new V2PipelineTemplate();
        if (config.getTemplate() == null) {
            List<V2PipelineTemplate.Variable> variables = config.getVariables().entrySet().stream().map(v -> V2PipelineTemplate.Variable.builder().name((String)v.getKey()).defaultValue(v.getValue()).build()).collect(Collectors.toList());
            template.setVariables(variables);
        } else {
            template = this.templateLoader.load(config.getTemplate());
        }
        RenderContext renderContext = V2RenderUtil.createDefaultRenderContext(template, config, trigger);
        this.renderTemplateVariables(renderContext, template);
        context.setSchemaContext(new V2PipelineTemplateContext(config, template));
    }

    private void renderTemplateVariables(RenderContext renderContext, V2PipelineTemplate pipelineTemplate) {
        if (pipelineTemplate.getVariables() == null) {
            return;
        }
        List<V2PipelineTemplate.Variable> renderedVars = pipelineTemplate.getVariables().stream().map(v -> this.renderSingleVariable(renderContext, (V2PipelineTemplate.Variable)v)).collect(Collectors.toList());
        pipelineTemplate.setVariables(renderedVars);
    }

    private V2PipelineTemplate.Variable renderSingleVariable(RenderContext renderContext, V2PipelineTemplate.Variable v) {
        Object value = v.getDefaultValue();
        if (v.isNullable() && value == null) {
            return v;
        }
        Map resolvedVar = this.contextParameterProcessor.process((Map)this.objectMapper.convertValue((Object)v, MAP_TYPE_REFERENCE), renderContext.getVariables(), true);
        return (V2PipelineTemplate.Variable)this.objectMapper.convertValue((Object)resolvedVar, V2PipelineTemplate.Variable.class);
    }

    private void renderPipelineTemplateSource(V2TemplateConfiguration tc, Map<String, Object> trigger) {
        if (trigger == null || tc.getTemplate() == null) {
            return;
        }
        V2DefaultRenderContext renderContext = new V2DefaultRenderContext(tc.getApplication(), null, trigger);
        Map processedTemplate = this.contextParameterProcessor.process((Map)this.objectMapper.convertValue((Object)tc.getTemplate(), MAP_TYPE_REFERENCE), renderContext.getVariables(), true);
        tc.setTemplate((Artifact)this.objectMapper.convertValue((Object)processedTemplate, Artifact.class));
    }
}

