/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedContent;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedHashMap;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PartialDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateModule;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.VersionedSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PipelineTemplate
implements VersionedSchema {
    private String schema;
    private String id;
    private String source;
    private Metadata metadata = new Metadata();
    private Boolean protect = false;
    private List<Variable> variables = new ArrayList<Variable>();
    private Configuration configuration;
    private List<StageDefinition> stages;
    private List<TemplateModule> modules;
    private List<PartialDefinition> partials = new ArrayList<PartialDefinition>();

    @Override
    @JsonIgnore
    public String getSchemaVersion() {
        return this.schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Boolean getProtect() {
        return this.protect;
    }

    public void setProtect(Boolean protect) {
        this.protect = protect;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<StageDefinition> getStages() {
        return Optional.ofNullable(this.stages).orElse(Collections.emptyList());
    }

    public void setStages(List<StageDefinition> stages) {
        this.stages = stages;
    }

    public List<TemplateModule> getModules() {
        return this.modules;
    }

    public void setModules(List<TemplateModule> modules) {
        this.modules = modules;
    }

    public List<PartialDefinition> getPartials() {
        return this.partials;
    }

    public void setPartials(List<PartialDefinition> partials) {
        this.partials = partials;
    }

    public void accept(PipelineTemplateVisitor visitor) {
        visitor.visitPipelineTemplate(this);
    }

    public static class Configuration {
        private Map<String, Object> concurrentExecutions;
        private List<NamedHashMap> triggers;
        private List<NamedHashMap> parameters;
        private List<NamedHashMap> notifications;
        private List<HashMap<String, Object>> expectedArtifacts;

        public Map<String, Object> getConcurrentExecutions() {
            return Optional.ofNullable(this.concurrentExecutions).orElse(new HashMap());
        }

        public void setConcurrentExecutions(Map<String, Object> concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        public List<NamedHashMap> getTriggers() {
            return this.triggers;
        }

        public void setTriggers(List<NamedHashMap> triggers) {
            this.triggers = triggers;
        }

        public List<NamedHashMap> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<NamedHashMap> parameters) {
            this.parameters = parameters;
        }

        public List<NamedHashMap> getNotifications() {
            return this.notifications;
        }

        public void setNotifications(List<NamedHashMap> notifications) {
            this.notifications = notifications;
        }

        public List<HashMap<String, Object>> getExpectedArtifacts() {
            return this.expectedArtifacts;
        }

        public void setExpectedArtifacts(List<HashMap<String, Object>> expectedArtifacts) {
            this.expectedArtifacts = expectedArtifacts;
        }
    }

    public static class Variable
    implements NamedContent<Variable>,
    Cloneable {
        private String name;
        private String group;
        private String description;
        private String type;
        private Object defaultValue;
        private String example;
        private boolean nullable;
        private boolean merge = false;
        private boolean remove = false;

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGroup() {
            return Optional.ofNullable(this.group).orElse("General");
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getType() {
            return Optional.ofNullable(this.type).orElse("object");
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean isMerge() {
            return this.merge;
        }

        public void setMerge(boolean merge) {
            this.merge = merge;
        }

        @Override
        public boolean isRemove() {
            return this.remove;
        }

        public void setRemove(boolean remove) {
            this.remove = remove;
        }

        @Override
        public Variable merge(Variable overlay) {
            Variable v;
            try {
                v = (Variable)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Could not clone Variable", e);
            }
            if (overlay.group != null) {
                v.group = overlay.group;
            }
            if (overlay.description != null) {
                v.description = overlay.description;
            }
            if (overlay.type != null) {
                v.type = overlay.type;
            }
            if (overlay.defaultValue != null) {
                v.defaultValue = overlay.defaultValue;
            }
            if (overlay.example != null) {
                v.example = overlay.example;
            }
            return v;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static class Metadata {
        private String name;
        private String description;
        private String owner;
        private List<String> scopes = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }
    }
}

