/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.Conditional;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.Identifiable;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PartialDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class StageDefinition
implements Identifiable,
Conditional,
Cloneable {
    private static final Splitter ON_DOTS = Splitter.on((String)".");
    private String id;
    private String name;
    private InjectionRule inject;
    private Set<String> dependsOn = new LinkedHashSet<String>();
    private String type;
    private Object config;
    private List<Map<String, Object>> notifications = new ArrayList<Map<String, Object>>();
    private String comments;
    private List<String> when = new ArrayList<String>();
    private InheritanceControl inheritanceControl;
    private Set<String> requisiteStageRefIds = new LinkedHashSet<String>();
    private String loopWith;
    @JsonIgnore
    private List<StageDefinition> loopedStages = new ArrayList<StageDefinition>();
    @JsonIgnore
    private Map<String, Object> loopContext = new HashMap<String, Object>();
    @JsonIgnore
    private Boolean removed = false;
    @JsonIgnore
    private PartialDefinitionContext partialDefinitionContext;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return Optional.ofNullable(this.name).orElse(this.id);
    }

    public void setName(String name) {
        this.name = name;
    }

    public InjectionRule getInject() {
        return this.inject;
    }

    public void setInject(InjectionRule inject) {
        this.inject = inject;
    }

    public Set<String> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(Set<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getConfig() {
        return this.config;
    }

    @JsonIgnore
    public Map<String, Object> getConfigAsMap() {
        if (!(this.config instanceof Map)) {
            throw new IllegalStateException("Stage configuration has not been converted to a map yet");
        }
        return (Map)this.config;
    }

    public void setConfig(Object config) {
        this.config = config;
    }

    public List<Map<String, Object>> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<Map<String, Object>> notifications) {
        this.notifications = notifications;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public List<String> getWhen() {
        return this.when;
    }

    @Override
    public void setRemove() {
        this.removed = true;
    }

    public Boolean getRemoved() {
        return this.removed;
    }

    public void setWhen(List<String> when) {
        this.when = when;
    }

    public InheritanceControl getInheritanceControl() {
        return this.inheritanceControl;
    }

    public void setInheritanceControl(InheritanceControl inheritanceControl) {
        this.inheritanceControl = inheritanceControl;
    }

    public Set<String> getRequisiteStageRefIds() {
        return this.requisiteStageRefIds;
    }

    public void setRequisiteStageRefIds(Set<String> requisiteStageRefIds) {
        this.requisiteStageRefIds = requisiteStageRefIds;
    }

    public String getLoopWith() {
        return this.loopWith;
    }

    public void setLoopWith(String loopWith) {
        this.loopWith = loopWith;
    }

    public Map<String, Object> getLoopContext() {
        return this.loopContext;
    }

    public List<StageDefinition> getLoopedStages() {
        return this.loopedStages;
    }

    @JsonIgnore
    public boolean isPartialType() {
        return this.type != null && this.type.startsWith("partial.");
    }

    @JsonIgnore
    public boolean isLooping() {
        return !Strings.isNullOrEmpty((String)this.loopWith);
    }

    @JsonIgnore
    public String getPartialId() {
        if (this.type == null) {
            return null;
        }
        List bits = ON_DOTS.splitToList((CharSequence)this.type);
        return (String)bits.get(bits.size() - 1);
    }

    public PartialDefinitionContext getPartialDefinitionContext() {
        return this.partialDefinitionContext;
    }

    public void setPartialDefinitionContext(PartialDefinitionContext partialDefinitionContext) {
        this.partialDefinitionContext = partialDefinitionContext;
    }

    public Object clone() throws CloneNotSupportedException {
        StageDefinition stage = (StageDefinition)super.clone();
        stage.setDependsOn(new LinkedHashSet<String>(this.getDependsOn()));
        if (this.getConfig() instanceof Map) {
            stage.setConfig(new HashMap<String, Object>(this.getConfigAsMap()));
        } else {
            stage.setConfig(this.getConfig());
        }
        Collections.copy(stage.getNotifications(), this.getNotifications());
        Collections.copy(stage.getWhen(), this.getWhen());
        stage.loopContext = new LinkedHashMap<String, Object>(this.getLoopContext());
        return stage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageDefinition that = (StageDefinition)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public static class PartialDefinitionContext {
        private final PartialDefinition partialDefinition;
        private final StageDefinition markerStage;

        public PartialDefinitionContext(PartialDefinition partialDefinition, StageDefinition markerStage) {
            this.partialDefinition = partialDefinition;
            this.markerStage = markerStage;
        }

        public PartialDefinition getPartialDefinition() {
            return this.partialDefinition;
        }

        public StageDefinition getMarkerStage() {
            return this.markerStage;
        }
    }

    public static class InheritanceControl
    implements Cloneable {
        private Collection<Rule> merge;
        private Collection<Rule> replace;
        private Collection<Rule> remove;

        public Collection<Rule> getMerge() {
            return Optional.ofNullable(this.merge).orElse(new ArrayList());
        }

        public void setMerge(Collection<Rule> merge) {
            this.merge = merge;
        }

        public Collection<Rule> getReplace() {
            return Optional.ofNullable(this.replace).orElse(new ArrayList());
        }

        public void setReplace(Collection<Rule> replace) {
            this.replace = replace;
        }

        public Collection<Rule> getRemove() {
            return Optional.ofNullable(this.remove).orElse(new ArrayList());
        }

        public void setRemove(Collection<Rule> remove) {
            this.remove = remove;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public static class Rule {
            String path;
            Object value;

            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public Object getValue() {
                return this.value;
            }

            public void setValue(Object value) {
                this.value = value;
            }
        }
    }

    public static class InjectionRule
    implements Cloneable {
        private Boolean first = false;
        private Boolean last = false;
        private List<String> before;
        private List<String> after;

        public Boolean getFirst() {
            return this.first;
        }

        public void setFirst(Boolean first) {
            this.first = first;
        }

        public Boolean getLast() {
            return this.last;
        }

        public void setLast(Boolean last) {
            this.last = last;
        }

        public List<String> getBefore() {
            return this.before;
        }

        public void setBefore(List<String> before) {
            this.before = before;
        }

        public List<String> getAfter() {
            return this.after;
        }

        public void setAfter(List<String> after) {
            this.after = after;
        }

        public boolean hasAny() {
            return this.first != false || this.last != false || this.before != null || this.after != null;
        }

        public boolean hasMany() {
            int count = 0;
            if (this.first.booleanValue()) {
                ++count;
            }
            if (this.last.booleanValue()) {
                ++count;
            }
            if (this.before != null) {
                ++count;
            }
            if (this.after != null) {
                ++count;
            }
            return count > 1;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

