/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedHashMap;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PartialDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateModule;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.VersionedSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateConfiguration
implements VersionedSchema {
    private String schema;
    private PipelineDefinition pipeline = new PipelineDefinition();
    private PipelineConfiguration configuration = new PipelineConfiguration();
    private List<StageDefinition> stages;
    private List<TemplateModule> modules;
    private List<PartialDefinition> partials = new ArrayList<PartialDefinition>();
    private final String runtimeId = UUID.randomUUID().toString();

    @Override
    public String getSchemaVersion() {
        return this.schema;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public PipelineDefinition getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(PipelineDefinition pipeline) {
        this.pipeline = pipeline;
    }

    public PipelineConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PipelineConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<StageDefinition> getStages() {
        return Optional.ofNullable(this.stages).orElse(Collections.emptyList());
    }

    public void setStages(List<StageDefinition> stages) {
        this.stages = stages;
    }

    public List<TemplateModule> getModules() {
        return this.modules;
    }

    public void setModules(List<TemplateModule> modules) {
        this.modules = modules;
    }

    public List<PartialDefinition> getPartials() {
        return this.partials;
    }

    public void setPartials(List<PartialDefinition> partials) {
        this.partials = partials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateConfiguration)) {
            return false;
        }
        TemplateConfiguration other = (TemplateConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        PipelineDefinition this$pipeline = this.getPipeline();
        PipelineDefinition other$pipeline = other.getPipeline();
        if (this$pipeline == null ? other$pipeline != null : !((Object)this$pipeline).equals(other$pipeline)) {
            return false;
        }
        PipelineConfiguration this$configuration = this.getConfiguration();
        PipelineConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        List<StageDefinition> this$stages = this.getStages();
        List<StageDefinition> other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        List<TemplateModule> this$modules = this.getModules();
        List<TemplateModule> other$modules = other.getModules();
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        List<PartialDefinition> this$partials = this.getPartials();
        List<PartialDefinition> other$partials = other.getPartials();
        if (this$partials == null ? other$partials != null : !((Object)this$partials).equals(other$partials)) {
            return false;
        }
        String this$runtimeId = this.getRuntimeId();
        String other$runtimeId = other.getRuntimeId();
        return !(this$runtimeId == null ? other$runtimeId != null : !this$runtimeId.equals(other$runtimeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        PipelineDefinition $pipeline = this.getPipeline();
        result = result * 59 + ($pipeline == null ? 43 : ((Object)$pipeline).hashCode());
        PipelineConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        List<StageDefinition> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        List<TemplateModule> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        List<PartialDefinition> $partials = this.getPartials();
        result = result * 59 + ($partials == null ? 43 : ((Object)$partials).hashCode());
        String $runtimeId = this.getRuntimeId();
        result = result * 59 + ($runtimeId == null ? 43 : $runtimeId.hashCode());
        return result;
    }

    public String toString() {
        return "TemplateConfiguration(schema=" + this.getSchema() + ", pipeline=" + this.getPipeline() + ", configuration=" + this.getConfiguration() + ", stages=" + this.getStages() + ", modules=" + this.getModules() + ", partials=" + this.getPartials() + ", runtimeId=" + this.getRuntimeId() + ")";
    }

    public static class PipelineConfiguration {
        private List<String> inherit = new ArrayList<String>();
        private Map<String, Object> concurrentExecutions = new HashMap<String, Object>();
        private List<NamedHashMap> triggers = new ArrayList<NamedHashMap>();
        private List<NamedHashMap> parameters = new ArrayList<NamedHashMap>();
        private List<NamedHashMap> notifications = new ArrayList<NamedHashMap>();
        private List<HashMap<String, Object>> expectedArtifacts = new ArrayList<HashMap<String, Object>>();
        private String description;

        public List<String> getInherit() {
            return Optional.ofNullable(this.inherit).orElse(Collections.emptyList());
        }

        public void setInherit(List<String> inherit) {
            this.inherit = inherit;
        }

        public Map<String, Object> getConcurrentExecutions() {
            return this.concurrentExecutions;
        }

        public void setConcurrentExecutions(Map<String, Object> concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        public List<NamedHashMap> getTriggers() {
            return this.triggers;
        }

        public void setTriggers(List<NamedHashMap> triggers) {
            this.triggers = triggers;
        }

        public List<NamedHashMap> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<NamedHashMap> parameters) {
            this.parameters = parameters;
        }

        public List<NamedHashMap> getNotifications() {
            return this.notifications;
        }

        public void setNotifications(List<NamedHashMap> notifications) {
            this.notifications = notifications;
        }

        public List<HashMap<String, Object>> getExpectedArtifacts() {
            return this.expectedArtifacts;
        }

        public void setExpectedArtifacts(List<HashMap<String, Object>> expectedArtifacts) {
            this.expectedArtifacts = expectedArtifacts;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class TemplateSource {
        private String source;

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public TemplateSource() {
        }

        public TemplateSource(String source) {
            this.source = source;
        }
    }

    public static class PipelineDefinition {
        private String application;
        private String pipelineConfigId;
        private String name;
        private TemplateSource template;
        private Map<String, Object> variables = new HashMap<String, Object>();

        public String getApplication() {
            return this.application;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public String getPipelineConfigId() {
            return this.pipelineConfigId;
        }

        public void setPipelineConfigId(String pipelineConfigId) {
            this.pipelineConfigId = pipelineConfigId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TemplateSource getTemplate() {
            return this.template;
        }

        public void setTemplate(TemplateSource template) {
            this.template = template;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PipelineDefinition)) {
                return false;
            }
            PipelineDefinition other = (PipelineDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
                return false;
            }
            String this$pipelineConfigId = this.getPipelineConfigId();
            String other$pipelineConfigId = other.getPipelineConfigId();
            if (this$pipelineConfigId == null ? other$pipelineConfigId != null : !this$pipelineConfigId.equals(other$pipelineConfigId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            TemplateSource this$template = this.getTemplate();
            TemplateSource other$template = other.getTemplate();
            if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
                return false;
            }
            Map<String, Object> this$variables = this.getVariables();
            Map<String, Object> other$variables = other.getVariables();
            return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PipelineDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            String $pipelineConfigId = this.getPipelineConfigId();
            result = result * 59 + ($pipelineConfigId == null ? 43 : $pipelineConfigId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            TemplateSource $template = this.getTemplate();
            result = result * 59 + ($template == null ? 43 : $template.hashCode());
            Map<String, Object> $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
            return result;
        }

        public String toString() {
            return "TemplateConfiguration.PipelineDefinition(application=" + this.getApplication() + ", pipelineConfigId=" + this.getPipelineConfigId() + ", name=" + this.getName() + ", template=" + this.getTemplate() + ", variables=" + this.getVariables() + ")";
        }
    }
}

