/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.FatalTemplateErrorsException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.loader.ResourceLocator;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.JsonRenderedValueConverter;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderedValueConverter;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.filters.Base64Filter;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.filters.FriggaFilter;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.filters.JsonFilter;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.filters.MaxFilter;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.filters.MinFilter;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.tags.ModuleTag;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.tags.PipelineIdTag;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.tags.StrategyIdTag;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.parser.ParserException;

public class JinjaRenderer
implements Renderer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Jinjava jinja;
    private Jinjava nullableJinja;
    private RenderedValueConverter renderedValueConverter;

    public JinjaRenderer(ObjectMapper pipelineTemplateObjectMapper, Front50Service front50Service, List<Tag> jinjaTags) {
        this(new JsonRenderedValueConverter(pipelineTemplateObjectMapper), pipelineTemplateObjectMapper, front50Service, jinjaTags);
    }

    public JinjaRenderer(RenderedValueConverter renderedValueConverter, ObjectMapper pipelineTemplateObjectMapper, Front50Service front50Service, List<Tag> jinjaTags) {
        if (front50Service == null) {
            this.log.error("Pipeline templates require front50 to enabled. Set 'front50.enabled: true' in your orca config.");
            return;
        }
        this.renderedValueConverter = renderedValueConverter;
        this.jinja = this.createJinjaRenderer(true, pipelineTemplateObjectMapper, front50Service, jinjaTags);
        this.nullableJinja = this.createJinjaRenderer(false, pipelineTemplateObjectMapper, front50Service, jinjaTags);
        this.log.info("PipelineTemplates: Using JinjaRenderer");
    }

    private Jinjava createJinjaRenderer(boolean failOnUnknownTokens, ObjectMapper pipelineTemplateObjectMapper, Front50Service front50Service, List<Tag> jinjaTags) {
        Jinjava jinja = new Jinjava(JinjaRenderer.buildJinjavaConfig(failOnUnknownTokens));
        jinja.setResourceLocator((ResourceLocator)new NoopResourceLocator());
        jinja.getGlobalContext().registerTag((Tag)new ModuleTag(this, pipelineTemplateObjectMapper));
        jinja.getGlobalContext().registerTag((Tag)new PipelineIdTag(front50Service));
        jinja.getGlobalContext().registerTag((Tag)new StrategyIdTag(front50Service));
        if (jinjaTags != null) {
            jinjaTags.forEach(tag -> jinja.getGlobalContext().registerTag(tag));
        }
        jinja.getGlobalContext().registerFilter((Filter)new FriggaFilter());
        jinja.getGlobalContext().registerFilter((Filter)new JsonFilter(pipelineTemplateObjectMapper));
        jinja.getGlobalContext().registerFilter((Filter)new Base64Filter(this));
        jinja.getGlobalContext().registerFilter((Filter)new MaxFilter());
        jinja.getGlobalContext().registerFilter((Filter)new MinFilter());
        return jinja;
    }

    @Override
    public String render(String template, RenderContext context) {
        String rendered;
        try {
            rendered = this.jinja.render(template, context.getVariables());
        }
        catch (FatalTemplateErrorsException fte) {
            List templateErrors = (List)fte.getErrors();
            List errorMessages = templateErrors.stream().map(TemplateError::getMessage).collect(Collectors.toList());
            Map<String, Object> contextVariables = context.getVariables();
            Predicate<String> nullableUnknownToken = key -> {
                Pattern unknownTokenPattern = Pattern.compile(String.format("UnknownTokenException[:\\s+\\w+]+%s", key));
                return contextVariables.containsKey(key) && contextVariables.get(key) == null && errorMessages.stream().anyMatch(msg -> unknownTokenPattern.matcher((CharSequence)msg).find());
            };
            if (contextVariables.keySet().stream().anyMatch(nullableUnknownToken)) {
                this.log.debug("Nullable variable referenced in template '{}'. Rendering template with unknown token tolerant Jinja renderer.");
                rendered = this.nullableJinja.render(template, context.getVariables());
            }
            this.log.error("Failed rendering jinja template", (Throwable)fte);
            throw new TemplateRenderException("failed rendering jinja template", (Throwable)fte, JinjaRenderer.unwrapJinjaTemplateErrorException(fte, context.getLocation()));
        }
        catch (InterpretException e) {
            this.log.warn("Caught supertype InterpretException instead of " + ((Object)((Object)e)).getClass().getSimpleName());
            this.log.error("Failed rendering jinja template", (Throwable)e);
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("failed rendering jinja template").withLocation(context.getLocation()), e);
        }
        rendered = rendered.trim();
        if (!template.equals(rendered)) {
            this.log.debug("rendered '" + template + "' -> '" + rendered + "'");
        }
        return rendered;
    }

    @Override
    public Object renderGraph(String template, RenderContext context) {
        String renderedValue = this.render(template, context);
        try {
            return this.renderedValueConverter.convertRenderedValue(renderedValue);
        }
        catch (ParserException e) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("Failed converting rendered value to YAML").withLocation(context.getLocation()).withDetail("source", template).withCause(e.getMessage()), e);
        }
    }

    private static Errors unwrapJinjaTemplateErrorException(FatalTemplateErrorsException e, String location) {
        Errors errors = new Errors();
        for (TemplateError templateError : e.getErrors()) {
            if (templateError.getException() instanceof TemplateRenderException) {
                TemplateRenderException tre = (TemplateRenderException)((Object)templateError.getException());
                errors.addAll(tre.getErrors());
                continue;
            }
            Errors.Error error = new Errors.Error().withMessage(templateError.getMessage()).withSeverity(templateError.getSeverity().equals((Object)TemplateError.ErrorType.FATAL) ? Errors.Severity.FATAL : Errors.Severity.WARN).withLocation(location);
            errors.add(error);
            if (templateError.getReason() != TemplateError.ErrorReason.OTHER) {
                error.withDetail("reason", templateError.getReason().name());
            }
            if (templateError.getItem() != TemplateError.ErrorItem.OTHER) {
                error.withDetail("item", templateError.getItem().name());
            }
            if (templateError.getFieldName() != null) {
                error.withDetail("fieldName", templateError.getFieldName());
            }
            if (templateError.getLineno() > 0) {
                error.withDetail("lineno", Integer.toString(templateError.getLineno()));
            }
            if (templateError.getCategory() != BasicTemplateErrorCategory.UNKNOWN) {
                error.withDetail("category", templateError.getCategory().toString());
                templateError.getCategoryErrors().forEach((s, s2) -> error.withDetail("categoryError:" + s, (String)s2));
            }
            if (templateError.getException() == null || !(templateError.getException().getCause() instanceof TemplateRenderException)) continue;
            error.withNested(((TemplateRenderException)((Object)templateError.getException().getCause())).getErrors());
        }
        return errors;
    }

    private static JinjavaConfig buildJinjavaConfig(boolean failOnUnknownTokens) {
        JinjavaConfig.Builder configBuilder = JinjavaConfig.newBuilder();
        configBuilder.withFailOnUnknownTokens(failOnUnknownTokens);
        HashMap<Context.Library, HashSet<String>> disabled = new HashMap<Context.Library, HashSet<String>>();
        disabled.put(Context.Library.TAG, new HashSet<String>(Arrays.asList("from", "import", "include")));
        configBuilder.withDisabled(disabled);
        return configBuilder.build();
    }

    private static class NoopResourceLocator
    implements ResourceLocator {
        private NoopResourceLocator() {
        }

        public String getString(String fullName, Charset encoding, JinjavaInterpreter interpreter) throws IOException {
            return null;
        }
    }
}

