/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderedValueConverter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.math.NumberUtils;

public class JsonRenderedValueConverter
implements RenderedValueConverter {
    private ObjectMapper pipelineTemplateObjectMapper;

    public JsonRenderedValueConverter(ObjectMapper pipelineTemplateObjectMapper) {
        this.pipelineTemplateObjectMapper = pipelineTemplateObjectMapper;
    }

    @Override
    public Object convertRenderedValue(String rendered) {
        JsonNode node;
        if (NumberUtils.isNumber((String)rendered)) {
            if (rendered.contains(".")) {
                return NumberUtils.createDouble((String)rendered);
            }
            try {
                return NumberUtils.createInteger((String)rendered);
            }
            catch (NumberFormatException ignored) {
                return NumberUtils.createLong((String)rendered);
            }
        }
        if (rendered.equals("true") || rendered.equals("false")) {
            return Boolean.parseBoolean(rendered);
        }
        if (rendered.startsWith("{{") || !rendered.startsWith("{") && !rendered.startsWith("[")) {
            return rendered;
        }
        try {
            node = this.pipelineTemplateObjectMapper.readTree(rendered);
        }
        catch (IOException e) {
            throw new TemplateRenderException("template produced invalid json", e);
        }
        try {
            if (node.isArray()) {
                return this.pipelineTemplateObjectMapper.readValue(rendered, Collection.class);
            }
            if (node.isObject()) {
                return this.pipelineTemplateObjectMapper.readValue(rendered, HashMap.class);
            }
            if (node.isBoolean()) {
                return Boolean.parseBoolean(node.asText());
            }
            if (node.isDouble()) {
                return node.doubleValue();
            }
            if (node.canConvertToInt()) {
                return node.intValue();
            }
            if (node.canConvertToLong()) {
                return node.longValue();
            }
            if (node.isTextual()) {
                return node.textValue();
            }
            if (node.isNull()) {
                return null;
            }
        }
        catch (IOException e) {
            throw new TemplateRenderException("template produced invalid json", e);
        }
        throw new TemplateRenderException("unknown rendered object type");
    }
}

