/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render;

import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.DefaultRenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class RenderUtil {
    private static final int MAX_RENDER_DEPTH = 5;

    public static Object deepRender(Renderer renderer, Object obj, RenderContext context) {
        return RenderUtil.deepRender(renderer, obj, context, 0);
    }

    private static Object deepRender(Renderer renderer, Object obj, RenderContext context, int depth) {
        if (depth >= 5) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage(String.format("Cannot exceed %d levels of depth in handlebars rendering", 5)).withSuggestion("Try breaking up your templates into smaller, more reusable chunks via modules").withLocation(context.getLocation()));
        }
        if (obj == null) {
            return null;
        }
        if (RenderUtil.isPrimitive(obj)) {
            if (CharSequence.class.isInstance(obj)) {
                Object rendered = renderer.renderGraph((String)obj, context);
                if (rendered instanceof Collection || rendered instanceof Map) {
                    return RenderUtil.deepRender(renderer, rendered, context, depth + 1);
                }
                return rendered;
            }
            return obj;
        }
        if (obj instanceof Collection) {
            ArrayList<Object> objList = new ArrayList<Object>();
            for (Object o : (Collection)obj) {
                objList.add(RenderUtil.deepRender(renderer, o, context, depth));
            }
            return objList;
        }
        if (obj instanceof Map) {
            LinkedHashMap<String, Object> objMap = new LinkedHashMap<String, Object>();
            for (Map.Entry e : ((Map)obj).entrySet()) {
                objMap.put((String)RenderUtil.deepRender(renderer, e.getKey(), context, depth), RenderUtil.deepRender(renderer, e.getValue(), context, depth));
            }
            return objMap;
        }
        throw TemplateRenderException.fromError(new Errors.Error().withMessage("Unknown rendered type, cannot continue").withCause("Unhandled type: " + obj.getClass().getSimpleName()).withSuggestion("Expected types: primitives, collections and maps").withLocation(context.getLocation()));
    }

    private static boolean isPrimitive(Object o) {
        return CharSequence.class.isInstance(o) || Number.class.isInstance(o) || Boolean.class.isInstance(o);
    }

    public static RenderContext createDefaultRenderContext(PipelineTemplate template, TemplateConfiguration configuration, Map<String, Object> trigger) {
        DefaultRenderContext context = new DefaultRenderContext(configuration.getPipeline().getApplication(), template, trigger);
        RenderUtil.addTemplateVariablesToContext(template, context);
        if (configuration.getPipeline().getVariables() != null) {
            context.getVariables().putAll(configuration.getPipeline().getVariables());
        }
        return context;
    }

    public static void addTemplateVariablesToContext(PipelineTemplate template, RenderContext context) {
        if (template != null && template.getVariables() != null) {
            template.getVariables().stream().filter(v -> v.isNullable() && v.getDefaultValue() == null || v.hasDefaultValue()).forEach(v -> context.getVariables().put(v.getName(), v.getDefaultValue()));
        }
    }
}

