/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render;

import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderedValueConverter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.composer.ComposerException;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.parser.ParserException;

public class YamlRenderedValueConverter
implements RenderedValueConverter {
    private static final List<String> YAML_KEYWORDS = Arrays.asList("yes", "no", "on", "off");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<Yaml> yaml = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)new SafeConstructor()));

    @Override
    public Object convertRenderedValue(String renderedValue) {
        if (YamlRenderedValueConverter.containsEL(renderedValue) || YamlRenderedValueConverter.isYamlKeyword(renderedValue) || YamlRenderedValueConverter.containsYamlParsingExceptions(renderedValue)) {
            return renderedValue;
        }
        if (YamlRenderedValueConverter.containsNoExpandMarker(renderedValue)) {
            return YamlRenderedValueConverter.trimNoExpandMarker(renderedValue);
        }
        try {
            Object converted = yaml.get().load(renderedValue);
            if (converted == null || converted instanceof String) {
                return "".equals(converted) || "".equals(renderedValue) ? null : renderedValue;
            }
            return converted;
        }
        catch (ComposerException ce) {
            throw new TemplateRenderException("template produced invalid yaml", ce);
        }
        catch (ParserException pe) {
            if (pe.getProblem().contains("expected '<document start>'")) {
                this.log.info("YAML parser expected start of document, assuming rendered value is desired state");
                return renderedValue;
            }
            throw pe;
        }
    }

    private static boolean containsEL(String renderedValue) {
        return renderedValue.trim().startsWith("${");
    }

    private static boolean isYamlKeyword(String renderedValue) {
        return YAML_KEYWORDS.contains(renderedValue.toLowerCase());
    }

    private static boolean containsYamlParsingExceptions(String renderedValue) {
        return renderedValue != null && (renderedValue.startsWith("*") || renderedValue.startsWith("@class"));
    }

    private static boolean containsNoExpandMarker(String renderedValue) {
        return renderedValue.startsWith("noexpand:");
    }

    private static String trimNoExpandMarker(String renderedValue) {
        return renderedValue.substring("noexpand:".length(), renderedValue.length());
    }
}

