/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.filters;

import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.DefaultRenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderUtil;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class Base64Filter
implements Filter {
    private Renderer renderer;

    public Base64Filter(Renderer renderer) {
        this.renderer = renderer;
    }

    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (var == null) {
            return null;
        }
        if (args.length != 0) {
            throw new InterpretException("base64 does not accept any arguments");
        }
        Context context = interpreter.getContext();
        DefaultRenderContext renderContext = new DefaultRenderContext((String)context.get((Object)"application"), (PipelineTemplate)context.get((Object)"pipelineTemplate"), (Map)context.get((Object)"trigger", new HashMap()));
        renderContext.setLocation("base64");
        renderContext.getVariables().putAll((Map<String, Object>)context);
        Object value = var;
        try {
            value = RenderUtil.deepRender(this.renderer, value, renderContext);
        }
        catch (InterpretException e) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("Failed rendering base64 contents").withLocation(renderContext.getLocation()).withDetail("source", value.toString()), e);
        }
        return Base64.getEncoder().encodeToString(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    public String getName() {
        return "base64";
    }
}

