/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;

public class JsonFilter
implements Filter {
    private ObjectMapper objectMapper;

    public JsonFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (args.length != 0) {
            throw new InterpretException("json filter does accept any arguments");
        }
        try {
            return this.objectMapper.writeValueAsString(var);
        }
        catch (JsonProcessingException e) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("failed converting object to json").withDetail("object", (String)var), e);
        }
    }

    public String getName() {
        return "json";
    }
}

