/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.filters;

import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MinFilter
implements Filter {
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (args.length != 0) {
            throw new InterpretException("min filter does not accept any arguments");
        }
        if (!(var instanceof Collection)) {
            throw new InterpretException("min filter can only be used with a list type object");
        }
        List casted = ((Collection)var).stream().map(v -> {
            try {
                return Double.valueOf(String.valueOf(v));
            }
            catch (NumberFormatException e) {
                throw new InterpretException(String.format("min filter requires list of numeric values, %s given", v), (Throwable)e);
            }
        }).collect(Collectors.toList());
        if (casted.isEmpty()) {
            throw new InterpretException("min filter must be provided a list of numeric values with at least one value");
        }
        Double min = (Double)Collections.min(casted);
        if (min % (double)min.intValue() == 0.0) {
            return min.intValue();
        }
        return min;
    }

    public String getName() {
        return "min";
    }
}

