/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.tags;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateStateException;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.UnknownTokenException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedHashMap;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateModule;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.DefaultRenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.RenderUtil;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ModuleTag
implements Tag {
    private static final Splitter ON_EQUALS = Splitter.on((String)"=");
    private Renderer renderer;
    private ObjectMapper objectMapper;

    public ModuleTag(Renderer renderer, ObjectMapper pipelineTemplateObjectMapper) {
        this.renderer = renderer;
        this.objectMapper = pipelineTemplateObjectMapper;
    }

    public String getName() {
        return "module";
    }

    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        Object rendered;
        List<String> helper = ModuleTag.collapseWhitespaceInTokenPairs(new HelperStringTokenizer(tagNode.getHelpers()).allTokens());
        if (helper.isEmpty()) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'module' expects ID as first parameter: " + helper, tagNode.getLineNumber());
        }
        Context context = interpreter.getContext();
        String moduleId = helper.get(0);
        PipelineTemplate template = (PipelineTemplate)context.get((Object)"pipelineTemplate");
        if (template == null) {
            throw new TemplateStateException("Pipeline template missing from jinja context");
        }
        TemplateModule module = template.getModules().stream().filter(m -> m.getId().equals(moduleId)).findFirst().orElseThrow(() -> new TemplateRenderException(String.format("Module does not exist by ID: %s", moduleId)));
        DefaultRenderContext moduleContext = new DefaultRenderContext((String)context.get((Object)"application"), template, (Map)context.get((Object)"trigger"));
        moduleContext.setLocation("module:" + moduleId);
        RenderUtil.addTemplateVariablesToContext(template, moduleContext);
        HashMap paramPairs = new HashMap();
        helper.subList(1, helper.size()).forEach(p -> {
            List parts = ON_EQUALS.splitToList((CharSequence)p);
            if (parts.size() != 2) {
                throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'module' expects parameters to be in a 'key=value' format: " + helper, tagNode.getLineNumber());
            }
            paramPairs.put((String)parts.get(0), (String)parts.get(1));
        });
        ArrayList<String> missing = new ArrayList<String>();
        for (NamedHashMap var : module.getVariables()) {
            Object val = this.tryResolveExpression(interpreter, var.getName(), tagNode.getLineNumber());
            if (val == null) {
                if (paramPairs.containsKey(var.getName())) {
                    val = Optional.ofNullable(this.tryResolveExpression(interpreter, (String)paramPairs.get(var.getName()), tagNode.getLineNumber())).orElse(paramPairs.get(var.getName()));
                }
                if (val == null && var.containsKey("defaultValue")) {
                    val = var.get("defaultValue");
                }
                if (val == null) {
                    missing.add(var.getName());
                    continue;
                }
            }
            moduleContext.getVariables().put(var.getName(), val);
        }
        if (missing.size() > 0) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("Missing required variables in module").withCause("'" + StringUtils.join(missing, (String)"', '") + "' must be defined").withLocation(moduleContext.getLocation()).withDetail("source", tagNode.getMaster().getImage()));
        }
        try {
            rendered = RenderUtil.deepRender(this.renderer, module.getDefinition(), moduleContext);
        }
        catch (InterpretException e) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("Failed rendering module").withLocation(moduleContext.getLocation()).withDetail("source", tagNode.getMaster().getImage()), e);
        }
        if (rendered instanceof CharSequence) {
            return (String)rendered;
        }
        try {
            return this.objectMapper.writeValueAsString(rendered);
        }
        catch (JsonProcessingException e) {
            throw TemplateRenderException.fromError(new Errors.Error().withMessage("Failed rendering module as JSON").withLocation(moduleContext.getLocation()).withDetail("source", tagNode.getMaster().getImage()), e);
        }
    }

    public String getEndTagName() {
        return null;
    }

    private static List<String> collapseWhitespaceInTokenPairs(List<String> tokens) {
        int i;
        ArrayList<Object> combinedTokens = new ArrayList<Object>();
        combinedTokens.add(tokens.get(0));
        StringBuilder buffer = new StringBuilder();
        for (i = 1; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (token.contains("=")) {
                if (buffer.length() > 0) {
                    combinedTokens.add(buffer.toString());
                }
                buffer = new StringBuilder();
                combinedTokens.add(token);
                continue;
            }
            String lastToken = (String)combinedTokens.get(combinedTokens.size() - 1);
            if (lastToken.contains("=") && !lastToken.endsWith(",")) {
                buffer.append((String)combinedTokens.remove(combinedTokens.size() - 1));
            }
            buffer.append(token);
        }
        if (buffer.length() > 0) {
            i = combinedTokens.size() - 1;
            combinedTokens.set(i, (String)combinedTokens.get(i) + buffer.toString());
        }
        return combinedTokens.stream().map(ModuleTag::removeTrailingCommas).collect(Collectors.toList());
    }

    private static String removeTrailingCommas(String token) {
        if (token.endsWith(",")) {
            return token.substring(0, token.length() - 1);
        }
        return token;
    }

    private Object tryResolveExpression(JinjavaInterpreter interpreter, String expression, int lineNumber) {
        try {
            return interpreter.resolveELExpression(expression, lineNumber);
        }
        catch (UnknownTokenException unknownTokenException) {
            return null;
        }
    }
}

