/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.tags;

import com.google.common.base.Splitter;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StrategyIdTag
implements Tag {
    private static final Splitter ON_EQUALS = Splitter.on((String)"=");
    private static final String APPLICATION = "application";
    private static final String NAME = "name";
    private final Front50Service front50Service;

    public StrategyIdTag(Front50Service front50Service) {
        this.front50Service = front50Service;
    }

    public String getEndTagName() {
        return null;
    }

    public String getName() {
        return "strategyid";
    }

    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        List helper = new HelperStringTokenizer(tagNode.getHelpers()).splitComma(true).allTokens();
        if (helper.isEmpty()) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'strategyId' expects at least a strategy name: " + helper, tagNode.getLineNumber());
        }
        HashMap paramPairs = new HashMap();
        helper.forEach(p -> {
            List parts = ON_EQUALS.splitToList((CharSequence)p);
            if (parts.size() != 2) {
                throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'strategyId' expects parameters to be in a 'key=value' format: " + helper, tagNode.getLineNumber());
            }
            paramPairs.put((String)parts.get(0), (String)parts.get(1));
        });
        Context context = interpreter.getContext();
        String application = paramPairs.getOrDefault(APPLICATION, (String)context.get((Object)APPLICATION)).replaceAll("^[\"']|[\"']$", "");
        application = this.checkContext(application, context);
        String name = ((String)paramPairs.get(NAME)).replaceAll("^[\"']|[\"']$", "");
        name = this.checkContext(name, context);
        List<Map<String, Object>> strategies = Optional.ofNullable(this.front50Service.getStrategies(application)).orElse(Collections.emptyList());
        Map<String, Object> result = this.findStrategy(strategies, application, name);
        return (String)result.get("id");
    }

    private String checkContext(String param, Context context) {
        Object var = context.get((Object)param);
        if (var != null) {
            return (String)var;
        }
        return param;
    }

    private Map<String, Object> findStrategy(List<Map<String, Object>> strategies, String application, String strategyName) {
        return strategies.stream().filter(p -> p.get(NAME).equals(strategyName)).findFirst().orElseThrow(() -> TemplateRenderException.fromError(new Errors.Error().withMessage(String.format("Failed to find strategyId ID with name '%s' in application '%s'", strategyName, application))));
    }
}

