/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.validator;

import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import java.util.List;
import java.util.function.Function;

public class V1SchemaValidationHelper {
    public static void validateStageDefinitions(List<StageDefinition> stageDefinitions, Errors errors, Function<String, String> locationFormatter) {
        stageDefinitions.forEach(stageDefinition -> {
            if (stageDefinition.getId() == null) {
                errors.add(new Errors.Error().withMessage("Stage ID is unset").withLocation((String)locationFormatter.apply("stages")));
            }
            if (stageDefinition.getType() == null) {
                errors.add(new Errors.Error().withMessage("Stage is missing type").withLocation((String)locationFormatter.apply("stages." + stageDefinition.getId())));
            }
            if (stageDefinition.getConfig() == null) {
                errors.add(new Errors.Error().withMessage("Stage configuration is unset").withLocation((String)locationFormatter.apply("stages." + stageDefinition.getId())));
            }
            if (stageDefinition.getDependsOn() != null && !stageDefinition.getDependsOn().isEmpty() && stageDefinition.getInject() != null && stageDefinition.getInject().hasAny()) {
                errors.add(new Errors.Error().withMessage("A stage cannot have both dependsOn and an inject rule defined simultaneously").withLocation((String)locationFormatter.apply("stages." + stageDefinition.getId())));
            }
            if (stageDefinition.getInject() != null && stageDefinition.getInject().hasMany()) {
                errors.add(new Errors.Error().withMessage("A stage cannot have multiple inject rules defined").withLocation((String)locationFormatter.apply("stages." + stageDefinition.getId())));
            }
        });
    }
}

