/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.validator;

import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.validator.V1SchemaValidationHelper;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.SchemaValidator;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.ValidatorContext;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.VersionedSchema;
import java.util.List;

public class V1TemplateConfigurationSchemaValidator
implements SchemaValidator<SchemaValidatorContext> {
    private static final String SUPPORTED_VERSION = "1";

    @Override
    public void validate(VersionedSchema configuration, Errors errors, SchemaValidatorContext context) {
        TemplateConfiguration.PipelineDefinition pipelineDefinition;
        if (!(configuration instanceof TemplateConfiguration)) {
            throw new IllegalArgumentException("Expected TemplateConfiguration");
        }
        TemplateConfiguration config = (TemplateConfiguration)configuration;
        if (!SUPPORTED_VERSION.equals(config.getSchemaVersion())) {
            errors.add(new Errors.Error().withMessage("config schema version is unsupported: expected '1', got '" + config.getSchemaVersion() + "'"));
        }
        if ((pipelineDefinition = config.getPipeline()) == null) {
            errors.add(new Errors.Error().withMessage("Missing pipeline configuration").withLocation(V1TemplateConfigurationSchemaValidator.location("pipeline")));
        } else if (pipelineDefinition.getApplication() == null) {
            errors.add(new Errors.Error().withMessage("Missing 'application' pipeline configuration").withLocation(V1TemplateConfigurationSchemaValidator.location("pipeline.application")));
        }
        V1SchemaValidationHelper.validateStageDefinitions(config.getStages(), errors, V1TemplateConfigurationSchemaValidator::location);
        config.getStages().forEach(s -> {
            if (V1TemplateConfigurationSchemaValidator.shouldRequireDagRules(s, config, context.stageIds)) {
                errors.add(new Errors.Error().withMessage("A configuration-defined stage should have either dependsOn or an inject rule defined").withLocation(V1TemplateConfigurationSchemaValidator.location(String.format("stages.%s", s.getId()))).withSeverity(Errors.Severity.WARN));
            }
        });
    }

    private static boolean shouldRequireDagRules(StageDefinition s, TemplateConfiguration config, List<String> stageIds) {
        return !(config.getPipeline().getTemplate() == null || stageIds.contains(s.getId()) || s.getDependsOn() != null && !s.getDependsOn().isEmpty() || s.getInject() != null && s.getInject().hasAny());
    }

    private static String location(String location) {
        return "configuration:" + location;
    }

    public static class SchemaValidatorContext
    implements ValidatorContext {
        List<String> stageIds;

        public SchemaValidatorContext(List<String> stageIds) {
            this.stageIds = stageIds;
        }
    }
}

