/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.validator;

import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.validator.V1SchemaValidationHelper;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.SchemaValidator;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.ValidatorContext;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.VersionedSchema;

public class V1TemplateSchemaValidator<T extends SchemaValidatorContext>
implements SchemaValidator<T> {
    private static final String SUPPORTED_VERSION = "1";

    @Override
    public void validate(VersionedSchema pipelineTemplate, Errors errors, SchemaValidatorContext context) {
        if (!(pipelineTemplate instanceof PipelineTemplate)) {
            throw new IllegalArgumentException("Expected PipelineTemplate");
        }
        PipelineTemplate template = (PipelineTemplate)pipelineTemplate;
        if (!SUPPORTED_VERSION.equals(template.getSchemaVersion())) {
            errors.add(new Errors.Error().withMessage("template schema version is unsupported: expected '1', got '" + template.getSchemaVersion() + "'"));
        }
        if (template.getProtect().booleanValue() && context.configHasStages) {
            errors.add(new Errors.Error().withMessage("Modification of the stage graph (adding, removing, editing) is disallowed").withCause("The template being used has marked itself as protected"));
        }
        V1SchemaValidationHelper.validateStageDefinitions(template.getStages(), errors, V1TemplateSchemaValidator::location);
    }

    private static String location(String location) {
        return "template:" + location;
    }

    public static class SchemaValidatorContext
    implements ValidatorContext {
        boolean configHasStages = false;

        public SchemaValidatorContext(boolean configHasStages) {
            this.configHasStages = configHasStages;
        }
    }
}

