/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v1schema.validator.v2;

import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.SchemaValidator;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.ValidatorContext;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.VersionedSchema;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2TemplateConfigurationSchemaValidator
implements SchemaValidator<SchemaValidatorContext> {
    private static final String SUPPORTED_VERSION = "v2";
    private Logger log = LoggerFactory.getLogger(V2TemplateConfigurationSchemaValidator.class);

    @Override
    public void validate(VersionedSchema configuration, Errors errors, SchemaValidatorContext context) {
        if (!(configuration instanceof V2TemplateConfiguration)) {
            throw new IllegalArgumentException("Expected TemplateConfiguration");
        }
        V2TemplateConfiguration config = (V2TemplateConfiguration)configuration;
        if (!SUPPORTED_VERSION.equals(config.getSchemaVersion())) {
            errors.add(new Errors.Error().withMessage("config schema version is unsupported: expected 'v2', got '" + config.getSchemaVersion() + "'"));
        }
        if (config.getApplication() == null) {
            errors.add(new Errors.Error().withMessage("Missing 'application' configuration").withLocation(V2TemplateConfigurationSchemaValidator.location("application")));
        }
        config.getStages().forEach(s -> {
            if (V2TemplateConfigurationSchemaValidator.shouldRequireDagRules(s, config, context.stageIds)) {
                errors.add(new Errors.Error().withMessage("A configuration-defined stage should have either dependsOn or an inject rule defined").withLocation(V2TemplateConfigurationSchemaValidator.location(String.format("stages.%s", s.getRefId()))).withSeverity(Errors.Severity.WARN));
            }
        });
    }

    private static boolean shouldRequireDagRules(V2StageDefinition s, V2TemplateConfiguration config, List<String> stageIds) {
        return !(config.getTemplate() == null || stageIds.contains(s.getRefId()) || s.getRequisiteStageRefIds() != null && !s.getRequisiteStageRefIds().isEmpty() || s.getInject() != null && s.getInject().hasAny());
    }

    private static String location(String location) {
        return "configuration:" + location;
    }

    public static class SchemaValidatorContext
    implements ValidatorContext {
        List<String> stageIds;

        public SchemaValidatorContext(List<String> stageIds) {
            this.stageIds = stageIds;
        }
    }
}

