/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.NamedContent;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.V2PipelineTemplateVisitor;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2StageDefinition;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.VersionedSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class V2PipelineTemplate
implements VersionedSchema {
    public static final String SCHEMA = "schema";
    public static final String V2_SCHEMA_VERSION = "v2";
    private String schema;
    private String id;
    private Metadata metadata = new Metadata();
    private Boolean protect = false;
    private List<Variable> variables = new ArrayList<Variable>();
    private Map<String, Object> pipeline;

    @Override
    @JsonIgnore
    public String getSchemaVersion() {
        return this.schema;
    }

    public Map<String, Object> getPipeline() {
        return Optional.ofNullable(this.pipeline).orElse(Collections.EMPTY_MAP);
    }

    public List<V2StageDefinition> getStages() {
        Object pipelineStages = this.pipeline.get("stages");
        if (pipelineStages == null) {
            return Collections.emptyList();
        }
        ObjectMapper oj = new ObjectMapper();
        return (List)oj.convertValue(pipelineStages, (TypeReference)new TypeReference<List<V2StageDefinition>>(){});
    }

    public void setStages(List<V2StageDefinition> stages) {
        ObjectMapper oj = new ObjectMapper();
        TypeReference<List<Map<String, Object>>> mapTypeRef = new TypeReference<List<Map<String, Object>>>(){};
        this.pipeline.put("stages", oj.convertValue(stages, (TypeReference)mapTypeRef));
    }

    public void accept(V2PipelineTemplateVisitor visitor) {
        visitor.visitPipelineTemplate(this);
    }

    public List<Variable> getVariables() {
        return Optional.ofNullable(this.variables).orElse(Collections.emptyList());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getId() {
        return this.id;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Boolean getProtect() {
        return this.protect;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setProtect(Boolean protect) {
        this.protect = protect;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public void setPipeline(Map<String, Object> pipeline) {
        this.pipeline = pipeline;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V2PipelineTemplate)) {
            return false;
        }
        V2PipelineTemplate other = (V2PipelineTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$protect = this.getProtect();
        Boolean other$protect = other.getProtect();
        if (this$protect == null ? other$protect != null : !((Object)this$protect).equals(other$protect)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<Variable> this$variables = this.getVariables();
        List<Variable> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        Map<String, Object> this$pipeline = this.getPipeline();
        Map<String, Object> other$pipeline = other.getPipeline();
        return !(this$pipeline == null ? other$pipeline != null : !((Object)this$pipeline).equals(other$pipeline));
    }

    protected boolean canEqual(Object other) {
        return other instanceof V2PipelineTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $protect = this.getProtect();
        result = result * 59 + ($protect == null ? 43 : ((Object)$protect).hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<Variable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        Map<String, Object> $pipeline = this.getPipeline();
        result = result * 59 + ($pipeline == null ? 43 : ((Object)$pipeline).hashCode());
        return result;
    }

    public String toString() {
        return "V2PipelineTemplate(schema=" + this.getSchema() + ", id=" + this.getId() + ", metadata=" + this.getMetadata() + ", protect=" + this.getProtect() + ", variables=" + this.getVariables() + ", pipeline=" + this.getPipeline() + ")";
    }

    public static class Variable
    implements NamedContent<Variable>,
    Cloneable {
        public static final String TEMPLATE_VALID_VARIABLE_NAME_REGEX = "^[a-zA-Z0-9_]+$";
        private String name;
        private String description;
        private String type;
        private Object defaultValue;
        private String example;
        private boolean nullable;
        private boolean merge;
        private boolean remove;

        public String getType() {
            return Optional.ofNullable(this.type).orElse("object");
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        @Override
        public Variable merge(Variable overlay) {
            Variable v;
            try {
                v = (Variable)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Could not clone Variable", e);
            }
            if (overlay.description != null) {
                v.description = overlay.description;
            }
            if (overlay.type != null) {
                v.type = overlay.type;
            }
            if (overlay.defaultValue != null) {
                v.defaultValue = overlay.defaultValue;
            }
            if (overlay.example != null) {
                v.example = overlay.example;
            }
            return v;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public static VariableBuilder builder() {
            return new VariableBuilder();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getExample() {
            return this.example;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public boolean isMerge() {
            return this.merge;
        }

        @Override
        public boolean isRemove() {
            return this.remove;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setExample(String example) {
            this.example = example;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public void setMerge(boolean merge) {
            this.merge = merge;
        }

        public void setRemove(boolean remove) {
            this.remove = remove;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Variable)) {
                return false;
            }
            Variable other = (Variable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNullable() != other.isNullable()) {
                return false;
            }
            if (this.isMerge() != other.isMerge()) {
                return false;
            }
            if (this.isRemove() != other.isRemove()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Object this$defaultValue = this.getDefaultValue();
            Object other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            String this$example = this.getExample();
            String other$example = other.getExample();
            return !(this$example == null ? other$example != null : !this$example.equals(other$example));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Variable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNullable() ? 79 : 97);
            result = result * 59 + (this.isMerge() ? 79 : 97);
            result = result * 59 + (this.isRemove() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Object $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            String $example = this.getExample();
            result = result * 59 + ($example == null ? 43 : $example.hashCode());
            return result;
        }

        public String toString() {
            return "V2PipelineTemplate.Variable(name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", defaultValue=" + this.getDefaultValue() + ", example=" + this.getExample() + ", nullable=" + this.isNullable() + ", merge=" + this.isMerge() + ", remove=" + this.isRemove() + ")";
        }

        public Variable() {
        }

        public Variable(String name, String description, String type, Object defaultValue, String example, boolean nullable, boolean merge, boolean remove) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.defaultValue = defaultValue;
            this.example = example;
            this.nullable = nullable;
            this.merge = merge;
            this.remove = remove;
        }

        public static class VariableBuilder {
            private String name;
            private String description;
            private String type;
            private Object defaultValue;
            private String example;
            private boolean nullable;
            private boolean merge;
            private boolean remove;

            VariableBuilder() {
            }

            public VariableBuilder name(String name) {
                this.name = name;
                return this;
            }

            public VariableBuilder description(String description) {
                this.description = description;
                return this;
            }

            public VariableBuilder type(String type) {
                this.type = type;
                return this;
            }

            public VariableBuilder defaultValue(Object defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public VariableBuilder example(String example) {
                this.example = example;
                return this;
            }

            public VariableBuilder nullable(boolean nullable) {
                this.nullable = nullable;
                return this;
            }

            public VariableBuilder merge(boolean merge) {
                this.merge = merge;
                return this;
            }

            public VariableBuilder remove(boolean remove) {
                this.remove = remove;
                return this;
            }

            public Variable build() {
                return new Variable(this.name, this.description, this.type, this.defaultValue, this.example, this.nullable, this.merge, this.remove);
            }

            public String toString() {
                return "V2PipelineTemplate.Variable.VariableBuilder(name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", defaultValue=" + this.defaultValue + ", example=" + this.example + ", nullable=" + this.nullable + ", merge=" + this.merge + ", remove=" + this.remove + ")";
            }
        }
    }

    public static class Metadata {
        public static final String TEMPLATE_VALID_NAME_REGEX = "^[a-zA-z0-9-&\\s]+$";
        private String name;
        private String description;
        private String owner;
        private List<String> scopes = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getOwner() {
            return this.owner;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$owner = this.getOwner();
            String other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
                return false;
            }
            List<String> this$scopes = this.getScopes();
            List<String> other$scopes = other.getScopes();
            return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            List<String> $scopes = this.getScopes();
            result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
            return result;
        }

        public String toString() {
            return "V2PipelineTemplate.Metadata(name=" + this.getName() + ", description=" + this.getDescription() + ", owner=" + this.getOwner() + ", scopes=" + this.getScopes() + ")";
        }
    }
}

