/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.validator;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Errors {
    @JsonProperty
    List<Error> errors = new ArrayList<Error>();

    public Errors add(Error e) {
        this.errors.add(e);
        return this;
    }

    public Errors addAll(Errors errors) {
        this.errors.addAll(errors.errors);
        return this;
    }

    public boolean hasErrors(boolean includeWarn) {
        if (!includeWarn) {
            return this.errors.stream().filter(error -> error.severity != Severity.WARN).count() > 0L;
        }
        return !this.errors.isEmpty();
    }

    public Map<String, Object> toResponse() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("errors", this.errors.stream().map(Error::toResponse).collect(Collectors.toList()));
        return m;
    }

    public static class Error {
        Severity severity = Severity.FATAL;
        String message;
        String location;
        String cause;
        String suggestion;
        Errors nestedErrors;
        Map<String, String> details = new HashMap<String, String>();

        public Error withSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Error withMessage(String message) {
            this.message = message;
            return this;
        }

        public Error withLocation(String location) {
            this.location = location;
            return this;
        }

        public Error withCause(String cause) {
            this.cause = cause;
            return this;
        }

        public Error withNested(Errors errors) {
            this.nestedErrors = errors;
            return this;
        }

        public Error withSuggestion(String remedy) {
            this.suggestion = remedy;
            return this;
        }

        public Error withDetail(String key, String value) {
            this.details.put(key, value);
            return this;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCause() {
            return this.cause;
        }

        public String getSuggestion() {
            return this.suggestion;
        }

        public Map<String, String> getDetails() {
            return this.details;
        }

        public Errors getNestedErrors() {
            return this.nestedErrors;
        }

        public Map<String, Object> toResponse() {
            HashMap<String, Object> err = new HashMap<String, Object>();
            err.put("severity", this.severity.toString());
            if (this.message != null) {
                err.put("message", this.message);
            }
            if (this.location != null) {
                err.put("location", this.location);
            }
            if (this.cause != null) {
                err.put("cause", this.cause);
            }
            if (this.suggestion != null) {
                err.put("suggestion", this.suggestion);
            }
            if (!this.details.isEmpty()) {
                err.put("details", this.details);
            }
            if (this.nestedErrors != null && !this.nestedErrors.errors.isEmpty()) {
                err.put("nestedErrors", this.nestedErrors.errors.stream().map(Error::toResponse).collect(Collectors.toList()));
            }
            return err;
        }
    }

    public static enum Severity {
        FATAL,
        WARN;

    }
}

