/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.QosConfigurationProperties;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.pipeline.ExecutionLauncher;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.qos.DefaultExecutionPromoter;
import com.netflix.spinnaker.orca.qos.PromotionPolicy;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"com.netflix.spinnaker.orca.qos"})
@EnableConfigurationProperties(value={QosConfigurationProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0012"}, d2={"Lcom/netflix/spinnaker/config/QosConfiguration;", "", "()V", "executionPromoterAgent", "Lcom/netflix/spinnaker/orca/qos/DefaultExecutionPromoter;", "executionLauncher", "Lcom/netflix/spinnaker/orca/pipeline/ExecutionLauncher;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "policies", "", "Lcom/netflix/spinnaker/orca/qos/PromotionPolicy;", "registry", "Lcom/netflix/spectator/api/Registry;", "qosConfigurationProperties", "Lcom/netflix/spinnaker/config/QosConfigurationProperties;", "clusterLock", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "orca-qos"})
public class QosConfiguration {
    @Bean
    @ConditionalOnExpression(value="${pollers.qos.enabled:false}")
    @NotNull
    public DefaultExecutionPromoter executionPromoterAgent(@NotNull ExecutionLauncher executionLauncher, @NotNull ExecutionRepository executionRepository, @NotNull List<? extends PromotionPolicy> policies, @NotNull Registry registry, @NotNull QosConfigurationProperties qosConfigurationProperties, @NotNull NotificationClusterLock clusterLock) {
        Intrinsics.checkNotNullParameter((Object)executionLauncher, (String)"executionLauncher");
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter(policies, (String)"policies");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)qosConfigurationProperties, (String)"qosConfigurationProperties");
        Intrinsics.checkNotNullParameter((Object)clusterLock, (String)"clusterLock");
        return new DefaultExecutionPromoter(executionLauncher, executionRepository, policies, registry, qosConfigurationProperties.getPromoteIntervalMs(), clusterLock);
    }
}

