/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.qos;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.annotations.VisibleForTesting;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.notifications.AbstractPollingNotificationAgent;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.pipeline.ExecutionLauncher;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.qos.ExecutionPromoter;
import com.netflix.spinnaker.orca.qos.PromotionPolicy;
import com.netflix.spinnaker.orca.qos.PromotionResult;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import net.logstash.logback.argument.StructuredArguments;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001cB;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\rH\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0017R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/netflix/spinnaker/orca/qos/DefaultExecutionPromoter;", "Lcom/netflix/spinnaker/orca/qos/ExecutionPromoter;", "Lcom/netflix/spinnaker/orca/notifications/AbstractPollingNotificationAgent;", "executionLauncher", "Lcom/netflix/spinnaker/orca/pipeline/ExecutionLauncher;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "policies", "", "Lcom/netflix/spinnaker/orca/qos/PromotionPolicy;", "registry", "Lcom/netflix/spectator/api/Registry;", "pollingIntervalMs", "", "clusterLock", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "(Lcom/netflix/spinnaker/orca/pipeline/ExecutionLauncher;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Ljava/util/List;Lcom/netflix/spectator/api/Registry;JLcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;)V", "elapsedTimeId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "promotedId", "getNotificationType", "", "getPollingInterval", "tick", "", "NoPromotionPolicies", "orca-qos"})
public final class DefaultExecutionPromoter
extends AbstractPollingNotificationAgent
implements ExecutionPromoter {
    private final Logger log;
    private final Id elapsedTimeId;
    private final Id promotedId;
    private final ExecutionLauncher executionLauncher;
    private final ExecutionRepository executionRepository;
    private final List<PromotionPolicy> policies;
    private final Registry registry;
    private final long pollingIntervalMs;

    @VisibleForTesting
    public void tick() {
        this.registry.timer(this.elapsedTimeId).record(new Runnable(this){
            final /* synthetic */ DefaultExecutionPromoter this$0;

            public final void run() {
                PromotionResult promotionResult;
                boolean bl;
                Object object;
                boolean bl2;
                block4: {
                    List list = DefaultExecutionPromoter.access$getExecutionRepository$p(this.this$0).retrieveBufferedExecutions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionRepository.retrieveBufferedExecutions()");
                    Iterable $this$sortedByDescending$iv = list;
                    boolean $i$f$sortedByDescending = false;
                    bl2 = false;
                    object = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            PipelineExecution it = (PipelineExecution)b;
                            boolean bl2 = false;
                            PipelineExecution pipelineExecution = it;
                            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"it");
                            it = (PipelineExecution)a;
                            Comparable comparable = pipelineExecution.getBuildTime();
                            bl2 = false;
                            PipelineExecution pipelineExecution2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"it");
                            Long l = pipelineExecution2.getBuildTime();
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
                        }
                    });
                    bl = false;
                    bl2 = false;
                    List<PipelineExecution> it = object;
                    boolean bl3 = false;
                    PromotionResult lastResult = null;
                    List<PipelineExecution> candidates = it;
                    Iterable $this$forEach$iv = DefaultExecutionPromoter.access$getPolicies$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PromotionPolicy policy = (PromotionPolicy)element$iv;
                        boolean bl4 = false;
                        PromotionResult result = policy.apply((List<? extends PipelineExecution>)candidates);
                        if (result.getFinalized()) {
                            promotionResult = result;
                            break block4;
                        }
                        candidates = result.getCandidates();
                        lastResult = result;
                    }
                    promotionResult = lastResult;
                    if (promotionResult == null) {
                        promotionResult = new PromotionResult((List<? extends PipelineExecution>)candidates, true, "No promotion policy resulted in an action");
                    }
                }
                object = promotionResult;
                bl = false;
                bl2 = false;
                Object result = object;
                boolean bl5 = false;
                Iterable $this$forEach$iv = ((PromotionResult)result).getCandidates();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PipelineExecution it = (PipelineExecution)element$iv;
                    boolean bl6 = false;
                    DefaultExecutionPromoter.access$getLog$p(this.this$0).info("Promoting execution {} for work: {}", (Object)StructuredArguments.value((String)"executionId", (Object)it.getId()), (Object)((PromotionResult)result).getReason());
                    it.updateStatus(ExecutionStatus.NOT_STARTED);
                    DefaultExecutionPromoter.access$getExecutionRepository$p(this.this$0).updateStatus(it);
                    DefaultExecutionPromoter.access$getExecutionLauncher$p(this.this$0).start(it);
                }
                DefaultExecutionPromoter.access$getRegistry$p(this.this$0).counter(DefaultExecutionPromoter.access$getPromotedId$p(this.this$0)).increment((long)((PromotionResult)result).getCandidates().size());
            }
            {
                this.this$0 = defaultExecutionPromoter;
            }
        });
    }

    protected long getPollingInterval() {
        return this.pollingIntervalMs;
    }

    @NotNull
    protected String getNotificationType() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.simpleName");
        return string;
    }

    public DefaultExecutionPromoter(@NotNull ExecutionLauncher executionLauncher, @NotNull ExecutionRepository executionRepository, @NotNull List<? extends PromotionPolicy> policies, @NotNull Registry registry, long pollingIntervalMs, @NotNull NotificationClusterLock clusterLock) {
        Intrinsics.checkNotNullParameter((Object)executionLauncher, (String)"executionLauncher");
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter(policies, (String)"policies");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)clusterLock, (String)"clusterLock");
        super(clusterLock);
        this.executionLauncher = executionLauncher;
        this.executionRepository = executionRepository;
        this.policies = policies;
        this.registry = registry;
        this.pollingIntervalMs = pollingIntervalMs;
        this.log = LoggerFactory.getLogger(ExecutionPromoter.class);
        this.elapsedTimeId = this.registry.createId("qos.promoter.elapsedTime");
        this.promotedId = this.registry.createId("qos.promoter.executionsPromoted");
        if (this.policies.isEmpty()) {
            throw (Throwable)((Object)new NoPromotionPolicies("At least one PromotionPolicy must be defined"));
        }
    }

    public static final /* synthetic */ ExecutionRepository access$getExecutionRepository$p(DefaultExecutionPromoter $this) {
        return $this.executionRepository;
    }

    public static final /* synthetic */ List access$getPolicies$p(DefaultExecutionPromoter $this) {
        return $this.policies;
    }

    public static final /* synthetic */ Logger access$getLog$p(DefaultExecutionPromoter $this) {
        return $this.log;
    }

    public static final /* synthetic */ ExecutionLauncher access$getExecutionLauncher$p(DefaultExecutionPromoter $this) {
        return $this.executionLauncher;
    }

    public static final /* synthetic */ Registry access$getRegistry$p(DefaultExecutionPromoter $this) {
        return $this.registry;
    }

    public static final /* synthetic */ Id access$getPromotedId$p(DefaultExecutionPromoter $this) {
        return $this.promotedId;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/netflix/spinnaker/orca/qos/DefaultExecutionPromoter$NoPromotionPolicies;", "Lorg/springframework/beans/factory/BeanInitializationException;", "message", "", "(Ljava/lang/String;)V", "orca-qos"})
    private static final class NoPromotionPolicies
    extends BeanInitializationException {
        public NoPromotionPolicies(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

