/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.qos;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.annotations.Sync;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.events.BeforeInitialExecutionPersist;
import com.netflix.spinnaker.orca.qos.BufferAction;
import com.netflix.spinnaker.orca.qos.BufferPolicy;
import com.netflix.spinnaker.orca.qos.BufferResult;
import com.netflix.spinnaker.orca.qos.BufferState;
import com.netflix.spinnaker.orca.qos.BufferStateSupplier;
import com.netflix.spinnaker.orca.qos.ExecutionBufferActuator;
import com.netflix.spinnaker.orca.qos.ExecutionBufferActuator$WhenMappings;
import com.netflix.spinnaker.orca.qos.bufferstate.BufferStateSupplierProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.logstash.logback.argument.StructuredArguments;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J$\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00160\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000e*\u0004\u0018\u00010\u00130\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/netflix/spinnaker/orca/qos/ExecutionBufferActuator;", "", "bufferStateSupplierProvider", "Lcom/netflix/spinnaker/orca/qos/bufferstate/BufferStateSupplierProvider;", "configService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "registry", "Lcom/netflix/spectator/api/Registry;", "policies", "", "Lcom/netflix/spinnaker/orca/qos/BufferPolicy;", "(Lcom/netflix/spinnaker/orca/qos/bufferstate/BufferStateSupplierProvider;Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;Lcom/netflix/spectator/api/Registry;Ljava/util/List;)V", "bufferedId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "bufferingId", "elapsedTimeId", "enqueuedId", "log", "Lorg/slf4j/Logger;", "orderedPolicies", "beforeInitialPersist", "", "event", "Lcom/netflix/spinnaker/orca/events/BeforeInitialExecutionPersist;", "withActionDecision", "execution", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "fn", "Lkotlin/Function1;", "Lcom/netflix/spinnaker/orca/qos/BufferResult;", "orca-qos"})
public class ExecutionBufferActuator {
    private final Logger log;
    private final List<BufferPolicy> orderedPolicies;
    private final Id bufferingId;
    private final Id bufferedId;
    private final Id enqueuedId;
    private final Id elapsedTimeId;
    private final BufferStateSupplierProvider bufferStateSupplierProvider;
    private final DynamicConfigService configService;
    private final Registry registry;

    @Sync
    @EventListener(value={BeforeInitialExecutionPersist.class})
    public void beforeInitialPersist(@NotNull BeforeInitialExecutionPersist event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.configService.isEnabled("qos", false)) {
            return;
        }
        BufferStateSupplier bufferStateSupplier = this.bufferStateSupplierProvider.provide();
        String supplierName = bufferStateSupplier.getClass().getSimpleName();
        if ((BufferState)((Object)bufferStateSupplier.get()) == BufferState.ACTIVE) {
            this.registry.gauge(this.bufferingId).set(1.0);
            PipelineExecution pipelineExecution = event.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"event.execution");
            PipelineExecution execution = pipelineExecution;
            this.withActionDecision(execution, (Function1<? super BufferResult, Unit>)((Function1)new Function1<BufferResult, Unit>(this, supplierName, execution){
                final /* synthetic */ ExecutionBufferActuator this$0;
                final /* synthetic */ String $supplierName;
                final /* synthetic */ PipelineExecution $execution;

                public final void invoke(@NotNull BufferResult it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    switch (ExecutionBufferActuator$WhenMappings.$EnumSwitchMapping$0[it.getAction().ordinal()]) {
                        case 1: {
                            if (ExecutionBufferActuator.access$getConfigService$p(this.this$0).isEnabled("qos.learning-mode", true)) {
                                ExecutionBufferActuator.access$getLog$p(this.this$0).debug("Learning mode: Would have buffered execution {} (using " + this.$supplierName + "), reason: " + it.getReason(), (Object)StructuredArguments.value((String)"executionId", (Object)this.$execution.getId()));
                                ExecutionBufferActuator.access$getRegistry$p(this.this$0).counter(ExecutionBufferActuator.access$getBufferedId$p(this.this$0).withTag("learning", "true")).increment();
                                break;
                            }
                            ExecutionBufferActuator.access$getLog$p(this.this$0).warn("Buffering execution {} (using " + this.$supplierName + "), reason: " + it.getReason(), (Object)StructuredArguments.value((String)"executionId", (Object)this.$execution.getId()));
                            ExecutionBufferActuator.access$getRegistry$p(this.this$0).counter(ExecutionBufferActuator.access$getBufferedId$p(this.this$0).withTag("learning", "false")).increment();
                            this.$execution.setStatus(ExecutionStatus.BUFFERED);
                            break;
                        }
                        case 2: {
                            ExecutionBufferActuator.access$getLog$p(this.this$0).debug("Enqueuing execution {} (using " + this.$supplierName + "), reason: " + it.getReason(), (Object)StructuredArguments.value((String)"executionId", (Object)this.$execution.getId()));
                            ExecutionBufferActuator.access$getRegistry$p(this.this$0).counter(ExecutionBufferActuator.access$getEnqueuedId$p(this.this$0)).increment();
                            break;
                        }
                    }
                }
                {
                    this.this$0 = executionBufferActuator;
                    this.$supplierName = string;
                    this.$execution = pipelineExecution;
                    super(1);
                }
            }));
        } else {
            this.registry.gauge(this.bufferingId).set(0.0);
        }
    }

    public void withActionDecision(@NotNull PipelineExecution execution, @NotNull Function1<? super BufferResult, Unit> fn) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        this.registry.timer(this.elapsedTimeId).record(new Runnable(this, execution, fn){
            final /* synthetic */ ExecutionBufferActuator this$0;
            final /* synthetic */ PipelineExecution $execution;
            final /* synthetic */ Function1 $fn;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                block11: {
                    BufferResult bufferResult;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = ExecutionBufferActuator.access$getOrderedPolicies$p(this.this$0);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        Iterator<T> it;
                        BufferPolicy bufferPolicy = (BufferPolicy)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        BufferResult bufferResult2 = it.apply(this.$execution);
                        collection.add(bufferResult2);
                    }
                    List list = (List)destination$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    List bufferResults = list;
                    boolean bl3 = false;
                    if (bufferResults.isEmpty()) {
                        bufferResult = null;
                    } else {
                        Object v1;
                        block9: {
                            Iterable $this$firstOrNull$iv = bufferResults;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                BufferResult it = (BufferResult)element$iv;
                                boolean bl4 = false;
                                if (!it.getForce()) continue;
                                v1 = element$iv;
                                break block9;
                            }
                            v1 = null;
                        }
                        BufferResult forcedDecision = v1;
                        if (forcedDecision != null) {
                            bufferResult = forcedDecision;
                        } else {
                            boolean bl5;
                            block10: {
                                Iterable $this$all$iv = bufferResults;
                                boolean $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl5 = true;
                                } else {
                                    for (T element$iv : $this$all$iv) {
                                        BufferResult it = (BufferResult)element$iv;
                                        boolean bl6 = false;
                                        if (it.getAction() == BufferAction.ENQUEUE) continue;
                                        bl5 = false;
                                        break block10;
                                    }
                                    bl5 = true;
                                }
                            }
                            boolean enqueue = bl5;
                            String reasons2 = CollectionsKt.joinToString$default((Iterable)bufferResults, (CharSequence)", ", null, null, (int)0, null, (Function1)withActionDecision.2.reasons.1.INSTANCE, (int)30, null);
                            bufferResult = new BufferResult(enqueue ? BufferAction.ENQUEUE : BufferAction.BUFFER, false, reasons2);
                        }
                    }
                    if (bufferResult == null) break block11;
                    list = bufferResult;
                    bl = false;
                    bl2 = false;
                    List $this$run = list;
                    boolean bl7 = false;
                    this.$fn.invoke((Object)$this$run);
                }
            }
            {
                this.this$0 = executionBufferActuator;
                this.$execution = pipelineExecution;
                this.$fn = function1;
            }
        });
    }

    public ExecutionBufferActuator(@NotNull BufferStateSupplierProvider bufferStateSupplierProvider, @NotNull DynamicConfigService configService, @NotNull Registry registry, @NotNull List<? extends BufferPolicy> policies) {
        Intrinsics.checkNotNullParameter((Object)bufferStateSupplierProvider, (String)"bufferStateSupplierProvider");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(policies, (String)"policies");
        this.bufferStateSupplierProvider = bufferStateSupplierProvider;
        this.configService = configService;
        this.registry = registry;
        this.log = LoggerFactory.getLogger(ExecutionBufferActuator.class);
        Iterable $this$sortedByDescending$iv = policies;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        this.orderedPolicies = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                BufferPolicy it = (BufferPolicy)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getOrder());
                it = (BufferPolicy)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getOrder();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        }));
        this.bufferingId = this.registry.createId("qos.buffering");
        this.bufferedId = this.registry.createId("qos.executionsBuffered");
        this.enqueuedId = this.registry.createId("qos.executionsEnqueued");
        this.elapsedTimeId = this.registry.createId("qos.actuator.elapsedTime");
    }

    public static final /* synthetic */ DynamicConfigService access$getConfigService$p(ExecutionBufferActuator $this) {
        return $this.configService;
    }

    public static final /* synthetic */ Logger access$getLog$p(ExecutionBufferActuator $this) {
        return $this.log;
    }

    public static final /* synthetic */ Registry access$getRegistry$p(ExecutionBufferActuator $this) {
        return $this.registry;
    }

    public static final /* synthetic */ Id access$getBufferedId$p(ExecutionBufferActuator $this) {
        return $this.bufferedId;
    }

    public static final /* synthetic */ Id access$getEnqueuedId$p(ExecutionBufferActuator $this) {
        return $this.enqueuedId;
    }

    public static final /* synthetic */ List access$getOrderedPolicies$p(ExecutionBufferActuator $this) {
        return $this.orderedPolicies;
    }
}

