/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.qos.bufferpolicy;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.qos.BufferAction;
import com.netflix.spinnaker.orca.qos.BufferPolicy;
import com.netflix.spinnaker.orca.qos.BufferResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/netflix/spinnaker/orca/qos/bufferpolicy/EnqueueDeckOrchestrationsBufferPolicy;", "Lcom/netflix/spinnaker/orca/qos/BufferPolicy;", "()V", "apply", "Lcom/netflix/spinnaker/orca/qos/BufferResult;", "execution", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "getOrder", "", "orca-qos"})
public class EnqueueDeckOrchestrationsBufferPolicy
implements BufferPolicy {
    @Override
    @NotNull
    public BufferResult apply(@NotNull PipelineExecution execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        if (execution.getType() == ExecutionType.ORCHESTRATION && Intrinsics.areEqual((Object)execution.getOrigin(), (Object)"deck")) {
            return new BufferResult(BufferAction.ENQUEUE, true, "Deck-initiated orchestrations are always enqueued");
        }
        return new BufferResult(BufferAction.BUFFER, false, "Execution is not a deck-initiated orchestration");
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

