/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.qos.bufferpolicy;

import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.qos.BufferAction;
import com.netflix.spinnaker.orca.qos.BufferPolicy;
import com.netflix.spinnaker.orca.qos.BufferResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/spinnaker/orca/qos/bufferpolicy/NaiveBufferPolicy;", "Lcom/netflix/spinnaker/orca/qos/BufferPolicy;", "configService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "(Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;)V", "apply", "Lcom/netflix/spinnaker/orca/qos/BufferResult;", "execution", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "orca-qos"})
public class NaiveBufferPolicy
implements BufferPolicy {
    private final DynamicConfigService configService;

    @Override
    @NotNull
    public BufferResult apply(@NotNull PipelineExecution execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        if (!this.configService.isEnabled("qos.buffer-policy.naive", true)) {
            return new BufferResult(BufferAction.ENQUEUE, false, "Naive policy is disabled");
        }
        return new BufferResult(BufferAction.BUFFER, false, "Naive policy will always buffer executions");
    }

    public NaiveBufferPolicy(@NotNull DynamicConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.configService = configService;
    }

    @Override
    public int getOrder() {
        return BufferPolicy.DefaultImpls.getOrder(this);
    }
}

