/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.qos.bufferstate;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.qos.BufferState;
import com.netflix.spinnaker.orca.qos.BufferStateSupplier;
import com.netflix.spinnaker.orca.qos.bufferstate.ActiveExecutionsBufferStateSupplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0015\u0010\u000f\u001a\n \t*\u0004\u0018\u00010\u00100\u0010H\u0012\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/orca/qos/bufferstate/ActiveExecutionsBufferStateSupplier;", "Lcom/netflix/spinnaker/orca/qos/BufferStateSupplier;", "configService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "registry", "Lcom/netflix/spectator/api/Registry;", "(Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;Lcom/netflix/spectator/api/Registry;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "state", "Lcom/netflix/spinnaker/orca/qos/BufferState;", "enabled", "", "get", "getThreshold", "", "()Ljava/lang/Integer;", "updateCurrentState", "", "orca-qos"})
public class ActiveExecutionsBufferStateSupplier
implements BufferStateSupplier {
    private final Logger log;
    private BufferState state;
    private final DynamicConfigService configService;
    private final Registry registry;

    @Scheduled(fixedDelayString="${pollers.qos.update-state-interval-ms:5000}")
    private void updateCurrentState() {
        BufferState bufferState;
        Integer threshold;
        if (!this.enabled()) {
            this.state = BufferState.INACTIVE;
            return;
        }
        int activeExecutions2 = (int)((Number)this.registry.gauges().filter(updateCurrentState.activeExecutions.1.INSTANCE).map(updateCurrentState.activeExecutions.2.INSTANCE).reduce(updateCurrentState.activeExecutions.3.INSTANCE).get()).doubleValue();
        Integer n = threshold = this.getThreshold();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"threshold");
        if (activeExecutions2 > n) {
            if (this.state == BufferState.INACTIVE) {
                this.log.warn("Enabling buffering: System active executions over threshold (" + activeExecutions2 + '/' + threshold + ')');
            }
            bufferState = BufferState.ACTIVE;
        } else {
            if (this.state == BufferState.ACTIVE) {
                this.log.warn("Disabling buffering: System active executions below threshold (" + activeExecutions2 + '/' + threshold + ')');
            }
            bufferState = BufferState.INACTIVE;
        }
        this.state = bufferState;
    }

    @Override
    @NotNull
    public BufferState get() {
        return this.state;
    }

    @Override
    public boolean enabled() {
        return Intrinsics.areEqual((Object)((String)this.configService.getConfig(String.class, "qos.buffering-state.supplier", (Object)"")), (Object)"activeExecutions");
    }

    private Integer getThreshold() {
        return (Integer)this.configService.getConfig(Integer.TYPE, "qos.buffering-state.active-executions.threshold", (Object)100);
    }

    public ActiveExecutionsBufferStateSupplier(@NotNull DynamicConfigService configService, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.configService = configService;
        this.registry = registry;
        this.log = LoggerFactory.getLogger(ActiveExecutionsBufferStateSupplier.class);
        this.state = BufferState.INACTIVE;
    }

    @Override
    public int getOrder() {
        return BufferStateSupplier.DefaultImpls.getOrder(this);
    }
}

