/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.qos.bufferstate;

import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.qos.BufferState;
import com.netflix.spinnaker.orca.qos.BufferStateSupplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/spinnaker/orca/qos/bufferstate/KillSwitchBufferStateSupplier;", "Lcom/netflix/spinnaker/orca/qos/BufferStateSupplier;", "configService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "(Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;)V", "enabled", "", "get", "Lcom/netflix/spinnaker/orca/qos/BufferState;", "orca-qos"})
public class KillSwitchBufferStateSupplier
implements BufferStateSupplier {
    private final DynamicConfigService configService;

    @Override
    public boolean enabled() {
        return Intrinsics.areEqual((Object)((String)this.configService.getConfig(String.class, "qos.buffering-state.supplier", (Object)"")), (Object)"killSwitch");
    }

    @Override
    @NotNull
    public BufferState get() {
        BufferState bufferState;
        boolean bl = this.configService.isEnabled("qos.buffering-state.kill-switch", false);
        if (bl) {
            bufferState = BufferState.ACTIVE;
        } else if (!bl) {
            bufferState = BufferState.INACTIVE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bufferState;
    }

    public KillSwitchBufferStateSupplier(@NotNull DynamicConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.configService = configService;
    }

    @Override
    public int getOrder() {
        return BufferStateSupplier.DefaultImpls.getOrder(this);
    }
}

