/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.qos.promotionpolicy;

import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.qos.PromotionPolicy;
import com.netflix.spinnaker.orca.qos.PromotionResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/orca/qos/promotionpolicy/NaivePromotionPolicy;", "Lcom/netflix/spinnaker/orca/qos/PromotionPolicy;", "configService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "(Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;)V", "apply", "Lcom/netflix/spinnaker/orca/qos/PromotionResult;", "candidates", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "orca-qos"})
public class NaivePromotionPolicy
implements PromotionPolicy {
    private final DynamicConfigService configService;

    @Override
    @NotNull
    public PromotionResult apply(@NotNull List<? extends PipelineExecution> candidates) {
        Integer promoteSize;
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        if (!this.configService.isEnabled("qos.promotion-policy.naive", true)) {
            return new PromotionResult(candidates, false, "Naive policy is disabled");
        }
        Integer maxPromoteSize = (Integer)this.configService.getConfig(Integer.TYPE, "qos.promotion-policy.naive.size", (Object)1);
        Integer n = promoteSize = maxPromoteSize > candidates.size() ? Integer.valueOf(candidates.size()) : maxPromoteSize;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"promoteSize");
        return new PromotionResult(candidates.subList(0, n), false, "Naive policy promotes " + maxPromoteSize + " execution every cycle");
    }

    public NaivePromotionPolicy(@NotNull DynamicConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.configService = configService;
    }

    @Override
    public int getOrder() {
        return PromotionPolicy.DefaultImpls.getOrder(this);
    }
}

