/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.spinnaker.config.ObjectMapperSubtypeProperties;
import com.netflix.spinnaker.config.RedisQueueConfiguration;
import com.netflix.spinnaker.config.RedisQueueProperties;
import com.netflix.spinnaker.config.SpringObjectMapperConfigurer;
import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.q.migration.ExecutionTypeDeserializer;
import com.netflix.spinnaker.orca.q.migration.OrcaToKeikoSerializationMigrator;
import com.netflix.spinnaker.orca.q.migration.TaskTypeDeserializer;
import com.netflix.spinnaker.orca.q.redis.pending.RedisPendingExecutionService;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import com.netflix.spinnaker.q.redis.RedisClusterDeadMessageHandler;
import com.netflix.spinnaker.q.redis.RedisClusterQueue;
import com.netflix.spinnaker.q.redis.RedisDeadMessageHandler;
import com.netflix.spinnaker.q.redis.RedisQueue;
import java.time.Clock;
import java.util.Collection;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.util.Pool;

@Configuration
@EnableConfigurationProperties(value={ObjectMapperSubtypeProperties.class})
@ConditionalOnProperty(havingValue="true", matchIfMissing=true, value={"keiko.queue.redis.enabled"})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0017J \u0010\u0017\u001a\u00020\u00182\u000e\b\u0001\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0010H\u0017JN\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0001\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J \u0010\u000f\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0017\u00a8\u0006&"}, d2={"Lcom/netflix/spinnaker/config/RedisOrcaQueueConfiguration;", "Lcom/netflix/spinnaker/config/RedisQueueConfiguration;", "()V", "clusterQueue", "Lcom/netflix/spinnaker/q/redis/RedisClusterQueue;", "cluster", "Lredis/clients/jedis/JedisCluster;", "redisQueueProperties", "Lcom/netflix/spinnaker/config/RedisQueueProperties;", "clock", "Ljava/time/Clock;", "deadMessageHandler", "Lcom/netflix/spinnaker/q/redis/RedisClusterDeadMessageHandler;", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "redisQueueObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "orcaToKeikoSerializationMigrator", "Lcom/netflix/spinnaker/orca/q/migration/OrcaToKeikoSerializationMigrator;", "objectMapper", "pendingExecutionService", "Lcom/netflix/spinnaker/orca/q/redis/pending/RedisPendingExecutionService;", "jedisPool", "Lredis/clients/jedis/util/Pool;", "Lredis/clients/jedis/Jedis;", "mapper", "queue", "Lcom/netflix/spinnaker/q/redis/RedisQueue;", "redisPool", "Lcom/netflix/spinnaker/q/redis/RedisDeadMessageHandler;", "", "objectMapperSubtypeProperties", "Lcom/netflix/spinnaker/config/ObjectMapperSubtypeProperties;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "orca-queue-redis"})
public class RedisOrcaQueueConfiguration
extends RedisQueueConfiguration {
    @Autowired
    public void redisQueueObjectMapper(@NotNull ObjectMapper mapper, @NotNull ObjectMapperSubtypeProperties objectMapperSubtypeProperties, @NotNull TaskResolver taskResolver) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)objectMapperSubtypeProperties, (String)"objectMapperSubtypeProperties");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        ObjectMapper objectMapper = mapper;
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$apply = objectMapper;
        boolean bl3 = false;
        $this$apply.registerModule((Module)new KotlinModule(0, false, false, false, null, 31, null));
        $this$apply.registerModule((Module)new SimpleModule().addDeserializer(ExecutionType.class, (JsonDeserializer)new ExecutionTypeDeserializer()).addDeserializer(Class.class, (JsonDeserializer)new TaskTypeDeserializer(taskResolver)));
        $this$apply.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ObjectMapperSubtypeProperties objectMapperSubtypeProperties2 = objectMapperSubtypeProperties;
        boolean bl4 = false;
        boolean bl5 = false;
        ObjectMapperSubtypeProperties $this$apply2 = objectMapperSubtypeProperties2;
        boolean bl6 = false;
        ObjectMapperSubtypeProperties objectMapperSubtypeProperties3 = $this$apply2;
        objectMapperSubtypeProperties3.setMessagePackages(CollectionsKt.plus((Collection)objectMapperSubtypeProperties3.getMessagePackages(), (Iterable)CollectionsKt.listOf((Object)"com.netflix.spinnaker.orca.q")));
        ObjectMapperSubtypeProperties objectMapperSubtypeProperties4 = $this$apply2;
        objectMapperSubtypeProperties4.setAttributePackages(CollectionsKt.plus((Collection)objectMapperSubtypeProperties4.getAttributePackages(), (Iterable)CollectionsKt.listOf((Object)"com.netflix.spinnaker.orca.q")));
        Unit unit = Unit.INSTANCE;
        ObjectMapperSubtypeProperties objectMapperSubtypeProperties5 = objectMapperSubtypeProperties2;
        new SpringObjectMapperConfigurer(objectMapperSubtypeProperties5).registerSubtypes($this$apply);
    }

    @Bean
    @NotNull
    public OrcaToKeikoSerializationMigrator orcaToKeikoSerializationMigrator(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new OrcaToKeikoSerializationMigrator(objectMapper);
    }

    @Bean
    @ConditionalOnProperty(havingValue="false", matchIfMissing=true, value={"redis.cluster-enabled"})
    @Primary
    @NotNull
    public RedisQueue queue(@Qualifier(value="queueRedisPool") @NotNull Pool<Jedis> redisPool, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Clock clock, @NotNull RedisDeadMessageHandler deadMessageHandler, @NotNull EventPublisher publisher, @NotNull ObjectMapper mapper, @NotNull Optional<SerializationMigrator> serializationMigrator) {
        Intrinsics.checkNotNullParameter(redisPool, (String)"redisPool");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)deadMessageHandler, (String)"deadMessageHandler");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        return super.queue(redisPool, redisQueueProperties, clock, deadMessageHandler, publisher, mapper, serializationMigrator);
    }

    @Bean
    @ConditionalOnProperty(value={"redis.cluster-enabled"})
    @Primary
    @NotNull
    public RedisClusterQueue clusterQueue(@Qualifier(value="queueRedisCluster") @NotNull JedisCluster cluster, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Clock clock, @NotNull RedisClusterDeadMessageHandler deadMessageHandler, @NotNull EventPublisher publisher, @NotNull ObjectMapper redisQueueObjectMapper, @NotNull Optional<SerializationMigrator> serializationMigrator) {
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)deadMessageHandler, (String)"deadMessageHandler");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)redisQueueObjectMapper, (String)"redisQueueObjectMapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        return super.clusterQueue(cluster, redisQueueProperties, clock, deadMessageHandler, publisher, redisQueueObjectMapper, serializationMigrator);
    }

    @Bean
    @ConditionalOnProperty(matchIfMissing=true, value={"queue.pending-execution-service.redis.enabled"})
    @NotNull
    public RedisPendingExecutionService pendingExecutionService(@Qualifier(value="queueRedisPool") @NotNull Pool<Jedis> jedisPool, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter(jedisPool, (String)"jedisPool");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        return new RedisPendingExecutionService(jedisPool, mapper);
    }
}

