/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.RedisQueueProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.jedis.JedisDriverProperties;
import com.netflix.spinnaker.kork.jedis.JedisPoolFactory;
import com.netflix.spinnaker.orca.q.QueueShovel;
import com.netflix.spinnaker.q.Activator;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import com.netflix.spinnaker.q.redis.AbstractRedisQueue;
import com.netflix.spinnaker.q.redis.RedisClusterQueue;
import com.netflix.spinnaker.q.redis.RedisQueue;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.util.Pool;

@Configuration
@ConditionalOnProperty(value={"queue.redis.enabled"}, matchIfMissing=true)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017JD\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J^\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u001c\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001aj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0017Jd\u0010&\u001a\u00020'2\u000e\b\u0001\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u001c\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001aj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0017J2\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\b\u0001\u0010-\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0017J2\u00102\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\b\u0001\u0010-\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0017\u00a8\u00063"}, d2={"Lcom/netflix/spinnaker/config/RedisQueueShovelConfiguration;", "", "()V", "previousJedisCluster", "Lredis/clients/jedis/JedisCluster;", "mainConnection", "", "previousConnection", "timeout", "", "maxAttempts", "redisPoolConfig", "Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;", "Lredis/clients/jedis/Jedis;", "registry", "Lcom/netflix/spectator/api/Registry;", "previousQueueJedisPool", "Lredis/clients/jedis/util/Pool;", "previousRedisClusterQueue", "Lcom/netflix/spinnaker/q/redis/RedisClusterQueue;", "cluster", "redisQueueProperties", "Lcom/netflix/spinnaker/config/RedisQueueProperties;", "clock", "Ljava/time/Clock;", "deadMessageHandler", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/q/Queue;", "Lcom/netflix/spinnaker/q/Message;", "", "Lcom/netflix/spinnaker/q/DeadMessageCallback;", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "redisQueueObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "previousRedisQueue", "Lcom/netflix/spinnaker/q/redis/RedisQueue;", "redisPool", "priorRedisClusterQueueShovel", "Lcom/netflix/spinnaker/orca/q/QueueShovel;", "queue", "Lcom/netflix/spinnaker/q/redis/AbstractRedisQueue;", "previousQueueImpl", "discoveryActivator", "Lcom/netflix/spinnaker/q/Activator;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "redisQueueShovel", "orca-queue-redis"})
public class RedisQueueShovelConfiguration {
    @Bean
    @ConditionalOnProperty(value={"redis.connection-previous"})
    @ConditionalOnExpression(value="${redis.previous-cluster-enabled:false} == false")
    @NotNull
    public Pool<Jedis> previousQueueJedisPool(@Value(value="${redis.connection:redis://localhost:6379}") @NotNull String mainConnection, @Value(value="${redis.connection-previous:#{null}}") @Nullable String previousConnection, @Value(value="${redis.timeout:2000}") int timeout, @NotNull GenericObjectPoolConfig<Jedis> redisPoolConfig, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)mainConnection, (String)"mainConnection");
        Intrinsics.checkNotNullParameter(redisPoolConfig, (String)"redisPoolConfig");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (Intrinsics.areEqual((Object)mainConnection, (Object)previousConnection)) {
            throw new BeanInitializationException("previous Redis connection must not be the same as current connection");
        }
        JedisDriverProperties jedisDriverProperties = new JedisDriverProperties();
        boolean bl = false;
        boolean bl2 = false;
        JedisDriverProperties jedisDriverProperties2 = jedisDriverProperties;
        String string = "previousQueue";
        JedisPoolFactory jedisPoolFactory = new JedisPoolFactory(registry);
        boolean bl3 = false;
        $this$previousQueueJedisPool_u24lambda_u2d0.connection = previousConnection;
        $this$previousQueueJedisPool_u24lambda_u2d0.timeoutMs = timeout;
        $this$previousQueueJedisPool_u24lambda_u2d0.poolConfig = redisPoolConfig;
        Unit unit = Unit.INSTANCE;
        Pool pool = jedisPoolFactory.build(string, jedisDriverProperties, redisPoolConfig);
        Intrinsics.checkNotNullExpressionValue((Object)pool, (String)"JedisPoolFactory(registr\u2026    redisPoolConfig\n    )");
        return pool;
    }

    @Bean
    @ConditionalOnProperty(value={"redis.connection-previous"})
    @ConditionalOnExpression(value="${redis.previous-cluster-enabled:false} == true")
    @NotNull
    public JedisCluster previousJedisCluster(@Value(value="${redis.connection:redis://localhost:6379}") @NotNull String mainConnection, @Value(value="${redis.connection-previous}") @NotNull String previousConnection, @Value(value="${redis.timeout:2000}") int timeout, @Value(value="${redis.maxattempts:4}") int maxAttempts, @NotNull GenericObjectPoolConfig<Jedis> redisPoolConfig, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)mainConnection, (String)"mainConnection");
        Intrinsics.checkNotNullParameter((Object)previousConnection, (String)"previousConnection");
        Intrinsics.checkNotNullParameter(redisPoolConfig, (String)"redisPoolConfig");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (Intrinsics.areEqual((Object)mainConnection, (Object)previousConnection)) {
            throw new BeanInitializationException("previous Redis connection must not be the same as current connection");
        }
        URI uRI = URI.create(previousConnection);
        boolean bl = false;
        boolean bl2 = false;
        URI cx = uRI;
        boolean bl3 = false;
        int port = cx.getPort() == -1 ? 6379 : cx.getPort();
        String string = cx.getUserInfo();
        String password = string == null ? null : StringsKt.substringAfter$default((String)string, (String)":", null, (int)2, null);
        return new JedisCluster(new HostAndPort(cx.getHost(), port), timeout, timeout, maxAttempts, password, redisPoolConfig);
    }

    @Bean(name={"previousQueue"})
    @ConditionalOnBean(name={"previousQueueJedisPool"})
    @NotNull
    public RedisQueue previousRedisQueue(@Qualifier(value="previousQueueJedisPool") @NotNull Pool<Jedis> redisPool, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Clock clock, @NotNull Function2<? super Queue, ? super Message, Unit> deadMessageHandler, @NotNull EventPublisher publisher, @NotNull ObjectMapper redisQueueObjectMapper, @NotNull Optional<SerializationMigrator> serializationMigrator) {
        Intrinsics.checkNotNullParameter(redisPool, (String)"redisPool");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(deadMessageHandler, (String)"deadMessageHandler");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)redisQueueObjectMapper, (String)"redisQueueObjectMapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        String string = redisQueueProperties.getQueueName();
        List list = CollectionsKt.listOf(deadMessageHandler);
        Duration duration = Duration.ofSeconds(redisQueueProperties.getAckTimeoutSeconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(redisQueueProp\u2026kTimeoutSeconds.toLong())");
        return new RedisQueue(string, redisPool, clock, 0, redisQueueObjectMapper, serializationMigrator, (TemporalAmount)duration, list, false, publisher, 264, null);
    }

    @Bean(name={"previousClusterQueue"})
    @ConditionalOnBean(name={"previousJedisCluster"})
    @NotNull
    public RedisClusterQueue previousRedisClusterQueue(@Qualifier(value="previousJedisCluster") @NotNull JedisCluster cluster, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Clock clock, @NotNull Function2<? super Queue, ? super Message, Unit> deadMessageHandler, @NotNull EventPublisher publisher, @NotNull ObjectMapper redisQueueObjectMapper, @NotNull Optional<SerializationMigrator> serializationMigrator) {
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(deadMessageHandler, (String)"deadMessageHandler");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)redisQueueObjectMapper, (String)"redisQueueObjectMapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        String string = redisQueueProperties.getQueueName();
        List list = CollectionsKt.listOf(deadMessageHandler);
        Duration duration = Duration.ofSeconds(redisQueueProperties.getAckTimeoutSeconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(redisQueueProp\u2026kTimeoutSeconds.toLong())");
        return new RedisClusterQueue(string, cluster, clock, 0, redisQueueObjectMapper, serializationMigrator, (TemporalAmount)duration, list, false, publisher, 264, null);
    }

    @Bean
    @ConditionalOnBean(name={"previousQueueJedisPool"})
    @NotNull
    public QueueShovel redisQueueShovel(@NotNull AbstractRedisQueue queue, @Qualifier(value="previousQueue") @NotNull RedisQueue previousQueueImpl, @NotNull Registry registry, @NotNull Activator discoveryActivator, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)previousQueueImpl, (String)"previousQueueImpl");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)discoveryActivator, (String)"discoveryActivator");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        return new QueueShovel((Queue)queue, (Queue)previousQueueImpl, registry, discoveryActivator, dynamicConfigService, null);
    }

    @Bean
    @ConditionalOnBean(name={"previousClusterQueue"})
    @NotNull
    public QueueShovel priorRedisClusterQueueShovel(@NotNull AbstractRedisQueue queue, @Qualifier(value="previousClusterQueue") @NotNull AbstractRedisQueue previousQueueImpl, @NotNull Registry registry, @NotNull Activator discoveryActivator, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)previousQueueImpl, (String)"previousQueueImpl");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)discoveryActivator, (String)"discoveryActivator");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        return new QueueShovel((Queue)queue, (Queue)previousQueueImpl, registry, discoveryActivator, dynamicConfigService, null);
    }
}

