/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.redis.pending;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netflix/spinnaker/orca/q/redis/pending/RedisPendingExecutionService;", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "pool", "Lredis/clients/jedis/util/Pool;", "Lredis/clients/jedis/Jedis;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lredis/clients/jedis/util/Pool;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "depth", "", "pipelineConfigId", "", "enqueue", "", "message", "Lcom/netflix/spinnaker/q/Message;", "listName", "pendingIds", "", "popNewest", "popOldest", "purge", "callback", "Lkotlin/Function1;", "orca-queue-redis"})
public final class RedisPendingExecutionService
implements PendingExecutionService {
    @NotNull
    private final Pool<Jedis> pool;
    @NotNull
    private final ObjectMapper mapper;

    public RedisPendingExecutionService(@NotNull Pool<Jedis> pool, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.pool = pool;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(@NotNull String pipelineConfigId, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Closeable closeable = (Closeable)this.pool.getResource();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl3 = false;
            String[] stringArray = new String[]{this.mapper.writeValueAsString((Object)message)};
            Long l = redis.lpush(this.listName(pipelineConfigId), stringArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Message popOldest(@NotNull String pipelineConfigId) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Closeable closeable = (Closeable)this.pool.getResource();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Message message2;
            Jedis redis = (Jedis)closeable;
            boolean bl3 = false;
            String string = redis.rpop(this.listName(pipelineConfigId));
            if (string == null) {
                message2 = null;
            } else {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                ObjectMapper $this$readValue$iv = this.mapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                message2 = (Message)$this$readValue$iv.readValue(it, (TypeReference)new TypeReference<Message>(){});
            }
            message = message2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Message popNewest(@NotNull String pipelineConfigId) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Closeable closeable = (Closeable)this.pool.getResource();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Message message2;
            Jedis redis = (Jedis)closeable;
            boolean bl3 = false;
            String string = redis.lpop(this.listName(pipelineConfigId));
            if (string == null) {
                message2 = null;
            } else {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                ObjectMapper $this$readValue$iv = this.mapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                message2 = (Message)$this$readValue$iv.readValue(it, (TypeReference)new TypeReference<Message>(){});
            }
            message = message2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(@NotNull String pipelineConfigId, @NotNull Function1<? super Message, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Closeable closeable = (Closeable)this.pool.getResource();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl3 = false;
            while (true) {
                Long l = redis.llen(this.listName(pipelineConfigId));
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"redis.llen(listName(pipelineConfigId))");
                if (((Number)l).longValue() <= 0L) break;
                l = this.popOldest(pipelineConfigId);
                if (l == null) continue;
                Long l2 = l;
                boolean bl4 = false;
                boolean bl5 = false;
                callback.invoke((Object)l2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int depth(@NotNull String pipelineConfigId) {
        int n;
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Closeable closeable = (Closeable)this.pool.getResource();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Jedis redis = (Jedis)closeable;
            boolean bl3 = false;
            n = (int)redis.llen(this.listName(pipelineConfigId)).longValue();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return n;
    }

    @NotNull
    public List<String> pendingIds() {
        throw new NotImplementedError("only implemented on SqlPendingExecutionService");
    }

    private final String listName(String pipelineConfigId) {
        return "orca.pipeline.queue." + pipelineConfigId;
    }
}

