/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.SqlQueueProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.QueueShovel;
import com.netflix.spinnaker.q.Activator;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import com.netflix.spinnaker.q.sql.SqlDeadMessageHandler;
import com.netflix.spinnaker.q.sql.SqlQueue;
import java.time.Clock;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SqlQueueProperties.class})
@ConditionalOnProperty(value={"queue.shovel.enabled"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J<\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\b\b\u0001\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0017\u00a8\u0006\""}, d2={"Lcom/netflix/spinnaker/config/SqlQueueShovelConfiguration;", "", "()V", "previousSqlQueue", "Lcom/netflix/spinnaker/q/sql/SqlQueue;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deadMessageHandler", "Lcom/netflix/spinnaker/q/sql/SqlDeadMessageHandler;", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "properties", "Lcom/netflix/spinnaker/config/SqlQueueProperties;", "poolName", "", "sqlToSqlQueueShovel", "Lcom/netflix/spinnaker/orca/q/QueueShovel;", "queue", "previousQueue", "registry", "Lcom/netflix/spectator/api/Registry;", "activator", "Lcom/netflix/spinnaker/q/Activator;", "config", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "orca-queue-sql"})
public class SqlQueueShovelConfiguration {
    @Bean(name={"previousSqlQueue"})
    @ConditionalOnProperty(havingValue="sql-to-sql", value={"queue.shovel.kind"})
    @NotNull
    public SqlQueue previousSqlQueue(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ObjectMapper mapper, @NotNull SqlDeadMessageHandler deadMessageHandler, @NotNull EventPublisher publisher, @NotNull Optional<SerializationMigrator> serializationMigrator, @NotNull SqlQueueProperties properties, @Value(value="${queue.shovel.source-pool-name}") @NotNull String poolName) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)deadMessageHandler, (String)"deadMessageHandler");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        return new SqlQueue(properties.getQueueName(), 1, jooq, clock, properties.getLockTtlSeconds(), mapper, serializationMigrator, properties.getAckTimeout(), CollectionsKt.listOf((Object)deadMessageHandler), false, publisher, properties.getRetries(), null, poolName, 4608, null);
    }

    @Bean
    @ConditionalOnProperty(havingValue="sql-to-sql", value={"queue.shovel.kind"})
    @NotNull
    public QueueShovel sqlToSqlQueueShovel(@NotNull SqlQueue queue, @Qualifier(value="previousSqlQueue") @NotNull SqlQueue previousQueue, @NotNull Registry registry, @Qualifier(value="discoveryActivator") @NotNull Activator activator, @NotNull DynamicConfigService config, @NotNull ExecutionRepository executionRepository) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)previousQueue, (String)"previousQueue");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)activator, (String)"activator");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        return new QueueShovel((Queue)queue, (Queue)previousQueue, registry, activator, config, executionRepository);
    }
}

