/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.RedisQueueProperties;
import com.netflix.spinnaker.config.SqlQueueProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.jedis.JedisDriverProperties;
import com.netflix.spinnaker.kork.jedis.JedisPoolFactory;
import com.netflix.spinnaker.orca.q.QueueShovel;
import com.netflix.spinnaker.q.Activator;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import com.netflix.spinnaker.q.redis.AbstractRedisQueue;
import com.netflix.spinnaker.q.redis.RedisClusterQueue;
import com.netflix.spinnaker.q.redis.RedisQueue;
import com.netflix.spinnaker.q.sql.SqlQueue;
import java.time.Clock;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.util.Pool;

@Configuration
@EnableConfigurationProperties(value={RedisQueueProperties.class, SqlQueueProperties.class})
@ConditionalOnProperty(value={"queue.shovel.enabled"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017Jv\u0010\u001a\u001a\u00020\u00042\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J^\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017\u00a8\u0006'"}, d2={"Lcom/netflix/spinnaker/config/SqlRedisQueueShovelConfiguration;", "", "()V", "redisClusterToSqlQueueShovel", "Lcom/netflix/spinnaker/orca/q/QueueShovel;", "queue", "Lcom/netflix/spinnaker/q/sql/SqlQueue;", "cluster", "Lredis/clients/jedis/JedisCluster;", "clock", "Ljava/time/Clock;", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "redisQueueProperties", "Lcom/netflix/spinnaker/config/RedisQueueProperties;", "registry", "Lcom/netflix/spectator/api/Registry;", "discoveryActivator", "Lcom/netflix/spinnaker/q/Activator;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "redisToSqlQueueShovel", "mainConnection", "", "timeout", "", "redisPoolConfig", "Lorg/apache/commons/pool2/impl/GenericObjectPoolConfig;", "sqlToRedisQueueShovel", "Lcom/netflix/spinnaker/q/redis/AbstractRedisQueue;", "jooq", "Lorg/jooq/DSLContext;", "sqlQueueProperties", "Lcom/netflix/spinnaker/config/SqlQueueProperties;", "orca-queue-sql"})
public class SqlRedisQueueShovelConfiguration {
    @Bean
    @ConditionalOnBean(value={SqlQueue.class})
    @ConditionalOnProperty(havingValue="redis-to-sql", value={"queue.shovel.kind"})
    @NotNull
    public QueueShovel redisToSqlQueueShovel(@Value(value="${redis.connection:redis://localhost:6379}") @NotNull String mainConnection, @Value(value="${redis.timeout:2000}") int timeout, @NotNull GenericObjectPoolConfig<?> redisPoolConfig, @NotNull SqlQueue queue, @NotNull Clock clock, @NotNull EventPublisher publisher, @NotNull ObjectMapper mapper, @NotNull Optional<SerializationMigrator> serializationMigrator, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Registry registry, @NotNull Activator discoveryActivator, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)mainConnection, (String)"mainConnection");
        Intrinsics.checkNotNullParameter(redisPoolConfig, (String)"redisPoolConfig");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)discoveryActivator, (String)"discoveryActivator");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        JedisDriverProperties jedisDriverProperties = new JedisDriverProperties();
        boolean bl = false;
        boolean bl2 = false;
        JedisDriverProperties jedisDriverProperties2 = jedisDriverProperties;
        String string = "previousQueue";
        JedisPoolFactory jedisPoolFactory = new JedisPoolFactory(registry);
        boolean bl3 = false;
        $this$apply.connection = mainConnection;
        $this$apply.timeoutMs = timeout;
        $this$apply.poolConfig = redisPoolConfig;
        Unit unit = Unit.INSTANCE;
        Pool jedisPool = jedisPoolFactory.build(string, jedisDriverProperties, redisPoolConfig);
        String string2 = redisQueueProperties.getQueueName();
        Pool pool = jedisPool;
        Intrinsics.checkNotNullExpressionValue((Object)pool, (String)"jedisPool");
        Optional<SerializationMigrator> optional = serializationMigrator;
        bl2 = false;
        jedisDriverProperties2 = mapper;
        TemporalAmount temporalAmount = null;
        EventPublisher eventPublisher = publisher;
        List list = CollectionsKt.emptyList();
        RedisQueue previousQueue = new RedisQueue(string2, pool, clock, 0, (ObjectMapper)jedisDriverProperties2, optional, temporalAmount, list, bl2, eventPublisher, 328, null);
        return new QueueShovel((Queue)queue, (Queue)previousQueue, registry, discoveryActivator, dynamicConfigService, null);
    }

    @Bean
    @ConditionalOnBean(value={SqlQueue.class})
    @ConditionalOnProperty(havingValue="redis-cluster-to-sql", value={"queue.shovel.kind"})
    @NotNull
    public QueueShovel redisClusterToSqlQueueShovel(@NotNull SqlQueue queue, @NotNull JedisCluster cluster, @NotNull Clock clock, @NotNull EventPublisher publisher, @NotNull ObjectMapper mapper, @NotNull Optional<SerializationMigrator> serializationMigrator, @NotNull RedisQueueProperties redisQueueProperties, @NotNull Registry registry, @NotNull Activator discoveryActivator, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        Intrinsics.checkNotNullParameter((Object)redisQueueProperties, (String)"redisQueueProperties");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)discoveryActivator, (String)"discoveryActivator");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        RedisClusterQueue previousQueue = new RedisClusterQueue(redisQueueProperties.getQueueName(), cluster, clock, 0, mapper, serializationMigrator, null, CollectionsKt.emptyList(), false, publisher, 328, null);
        return new QueueShovel((Queue)queue, (Queue)previousQueue, registry, discoveryActivator, dynamicConfigService, null);
    }

    @Bean
    @ConditionalOnBean(value={AbstractRedisQueue.class})
    @ConditionalOnProperty(havingValue="sql-to-redis", value={"queue.shovel.kind"})
    @NotNull
    public QueueShovel sqlToRedisQueueShovel(@NotNull AbstractRedisQueue queue, @NotNull DSLContext jooq, @NotNull Clock clock, @NotNull EventPublisher publisher, @NotNull ObjectMapper mapper, @NotNull Optional<SerializationMigrator> serializationMigrator, @NotNull SqlQueueProperties sqlQueueProperties, @NotNull Registry registry, @NotNull Activator discoveryActivator, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        Intrinsics.checkNotNullParameter((Object)sqlQueueProperties, (String)"sqlQueueProperties");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)discoveryActivator, (String)"discoveryActivator");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        SqlQueue previousQueue = new SqlQueue(sqlQueueProperties.getQueueName(), 1, jooq, clock, sqlQueueProperties.getLockTtlSeconds(), mapper, serializationMigrator, null, CollectionsKt.emptyList(), false, publisher, sqlQueueProperties.getRetries(), null, null, 12928, null);
        return new QueueShovel((Queue)queue, (Queue)previousQueue, registry, discoveryActivator, dynamicConfigService, null);
    }
}

